package org.nuiton.db.meta;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ColumnRef}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableColumnRef.builder()}.
 */
@Generated(from = "ColumnRef", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableColumnRef implements ColumnRef {
  private final String table;
  private final @Nullable String column;

  private ImmutableColumnRef(String table, @Nullable String column) {
    this.table = table;
    this.column = column;
  }

  /**
   * @return The value of the {@code table} attribute
   */
  @Override
  public String getTable() {
    return table;
  }

  /**
   * @return The value of the {@code column} attribute
   */
  @Override
  public Optional<String> getColumn() {
    return Optional.ofNullable(column);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ColumnRef#getTable() table} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for table
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumnRef withTable(String value) {
    String newValue = Objects.requireNonNull(value, "table");
    if (this.table.equals(newValue)) return this;
    return new ImmutableColumnRef(newValue, this.column);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ColumnRef#getColumn() column} attribute.
   * @param value The value for column
   * @return A modified copy of {@code this} object
   */
  public final ImmutableColumnRef withColumn(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "column");
    if (Objects.equals(this.column, newValue)) return this;
    return new ImmutableColumnRef(this.table, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ColumnRef#getColumn() column} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for column
   * @return A modified copy of {@code this} object
   */
  public final ImmutableColumnRef withColumn(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.column, value)) return this;
    return new ImmutableColumnRef(this.table, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableColumnRef} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableColumnRef
        && equalTo((ImmutableColumnRef) another);
  }

  private boolean equalTo(ImmutableColumnRef another) {
    return table.equals(another.table)
        && Objects.equals(column, another.column);
  }

  /**
   * Computes a hash code from attributes: {@code table}, {@code column}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + table.hashCode();
    h += (h << 5) + Objects.hashCode(column);
    return h;
  }

  /**
   * Prints the immutable value {@code ColumnRef} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ColumnRef")
        .omitNullValues()
        .add("table", table)
        .add("column", column)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ColumnRef} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ColumnRef instance
   */
  public static ImmutableColumnRef copyOf(ColumnRef instance) {
    if (instance instanceof ImmutableColumnRef) {
      return (ImmutableColumnRef) instance;
    }
    return ImmutableColumnRef.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableColumnRef ImmutableColumnRef}.
   * <pre>
   * ImmutableColumnRef.builder()
   *    .table(String) // required {@link ColumnRef#getTable() table}
   *    .column(String) // optional {@link ColumnRef#getColumn() column}
   *    .build();
   * </pre>
   * @return A new ImmutableColumnRef builder
   */
  public static ImmutableColumnRef.Builder builder() {
    return new ImmutableColumnRef.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableColumnRef ImmutableColumnRef}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ColumnRef", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TABLE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String table;
    private @Nullable String column;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ColumnRef} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ColumnRef instance) {
      Objects.requireNonNull(instance, "instance");
      table(instance.getTable());
      Optional<String> columnOptional = instance.getColumn();
      if (columnOptional.isPresent()) {
        column(columnOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ColumnRef#getTable() table} attribute.
     * @param table The value for table 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder table(String table) {
      this.table = Objects.requireNonNull(table, "table");
      initBits &= ~INIT_BIT_TABLE;
      return this;
    }

    /**
     * Initializes the optional value {@link ColumnRef#getColumn() column} to column.
     * @param column The value for column
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder column(String column) {
      this.column = Objects.requireNonNull(column, "column");
      return this;
    }

    /**
     * Initializes the optional value {@link ColumnRef#getColumn() column} to column.
     * @param column The value for column
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder column(Optional<String> column) {
      this.column = column.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableColumnRef ImmutableColumnRef}.
     * @return An immutable instance of ColumnRef
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableColumnRef build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableColumnRef(table, column);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TABLE) != 0) attributes.add("table");
      return "Cannot build ColumnRef, some of required attributes are not set " + attributes;
    }
  }
}
