/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.config.example;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ApplicationConfigInit;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.config.example.NuitonConfigExampleConfigAction;
import org.nuiton.config.example.NuitonConfigExampleConfigOption;
import org.nuiton.config.io.ApplicationConfigReadFormat;

public abstract class GeneratedNuitonConfigExampleConfig
implements Supplier<ApplicationConfig> {
    private ApplicationConfig applicationConfig;

    protected GeneratedNuitonConfigExampleConfig() {
        this(ApplicationConfigInit.forAllScopes());
    }

    protected GeneratedNuitonConfigExampleConfig(ApplicationConfigInit init) {
        this.applicationConfig = new ApplicationConfig(init);
        this.applicationConfig.loadDefaultOptions((ConfigOptionDef[])NuitonConfigExampleConfigOption.values());
        this.applicationConfig.loadActions(NuitonConfigExampleConfigAction.class);
    }

    @Override
    public ApplicationConfig get() {
        return this.applicationConfig;
    }

    protected void setOption(String key, Object attrName) {
        this.applicationConfig.setOption(key, String.valueOf(attrName));
    }

    public String getFirstName() {
        return this.applicationConfig.getOption(NuitonConfigExampleConfigOption.FIRST_NAME.getKey());
    }

    public void setFirstName(String firstName) {
        this.setOption(NuitonConfigExampleConfigOption.FIRST_NAME.getKey(), firstName);
    }

    public String getLastName() {
        return this.applicationConfig.getOption(NuitonConfigExampleConfigOption.LAST_NAME.getKey());
    }

    public void setLastName(String lastName) {
        this.setOption(NuitonConfigExampleConfigOption.LAST_NAME.getKey(), lastName);
    }

    public String getEmail() {
        return this.applicationConfig.getOption(NuitonConfigExampleConfigOption.EMAIL.getKey());
    }

    public void setEmail(String email) {
        this.setOption(NuitonConfigExampleConfigOption.EMAIL.getKey(), email);
    }

    public String getTwitter() {
        return this.applicationConfig.getOption(NuitonConfigExampleConfigOption.TWITTER.getKey());
    }

    public void setTwitter(String twitter) {
        this.setOption(NuitonConfigExampleConfigOption.TWITTER.getKey(), twitter);
    }

    public int getAge() {
        return this.applicationConfig.getOptionAsInt(NuitonConfigExampleConfigOption.AGE.getKey());
    }

    public void setAge(int age) {
        this.setOption(NuitonConfigExampleConfigOption.AGE.getKey(), age);
    }

    public ApplicationConfigReadFormat getPreferredFormat() {
        return (ApplicationConfigReadFormat)this.applicationConfig.getOption(ApplicationConfigReadFormat.class, NuitonConfigExampleConfigOption.PREFERRED_FORMAT.getKey());
    }

    public void setPreferredFormat(ApplicationConfigReadFormat preferredFormat) {
        this.setOption(NuitonConfigExampleConfigOption.PREFERRED_FORMAT.getKey(), preferredFormat);
    }

    public String getConfigurationDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n=====================================================================================================================");
        builder.append("\n=== Configuration ===================================================================================================");
        builder.append("\n=====================================================================================================================");
        builder.append(String.format("\n=== %1$-40s = %2$s", "Filename", this.get().getConfigFileName()));
        for (NuitonConfigExampleConfigOption option : this.orderedByKey()) {
            builder.append(String.format("\n=== %1$-40s = %2$s", option.getKey(), this.get().getOption(option.getKey())));
        }
        builder.append("\n=====================================================================================================================");
        return builder.toString();
    }

    protected List<NuitonConfigExampleConfigOption> orderedByKey() {
        List<NuitonConfigExampleConfigOption> values = Arrays.asList(NuitonConfigExampleConfigOption.values());
        Collections.sort(values, new Comparator<NuitonConfigExampleConfigOption>(){

            @Override
            public int compare(NuitonConfigExampleConfigOption o1, NuitonConfigExampleConfigOption o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return Collections.unmodifiableList(values);
    }
}

