/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.maven.skin;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.doxia.siterenderer.DefaultSiteRenderer;
import org.apache.maven.doxia.siterenderer.DocumentRenderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.nuiton.maven.skin.ReflectUtil;
import org.nuiton.maven.skin.ScmwebeditorUtils;

public class NuitonSiteRenderer
extends DefaultSiteRenderer {
    protected SiteTool siteTool;
    protected Method createContextMethod;
    protected Method writeTemplateMethod;
    private String siteSourcesType;
    private List<Locale> locales;
    private Locale locale;
    private MavenProject mavenProject;
    private String scmwebeditorPrefixURL;
    private String siteXmlScmwebeditorURL;
    private boolean scmwebeditorEnabled;

    protected Method getWriteTemplateMethod() {
        if (this.writeTemplateMethod == null) {
            this.writeTemplateMethod = ReflectUtil.getMethod(((Object)((Object)this)).getClass().getSuperclass(), "writeTemplate", new Class[]{Writer.class, Context.class, SiteRenderingContext.class});
        }
        this.getLogger();
        return this.writeTemplateMethod;
    }

    protected Method getCreateContextMethod() {
        if (this.createContextMethod == null) {
            this.createContextMethod = ReflectUtil.getMethod(((Object)((Object)this)).getClass().getSuperclass(), "createContext", new Class[]{SiteRendererSink.class, SiteRenderingContext.class});
        }
        return this.createContextMethod;
    }

    public void render(Collection<DocumentRenderer> documents, SiteRenderingContext siteRenderingContext, File outputDirectory) throws RendererException, IOException {
        this.locale = siteRenderingContext.getLocale();
        Map templateProperties = siteRenderingContext.getTemplateProperties();
        String value = (String)templateProperties.get("scmwebeditorEnabled");
        boolean bl = this.scmwebeditorEnabled = StringUtils.isNotEmpty((String)value) && !"false".equals(value);
        if (this.scmwebeditorEnabled) {
            List locales;
            String localesAsStr = (String)templateProperties.get("locales");
            this.locales = locales = this.siteTool.getAvailableLocales(localesAsStr);
            this.mavenProject = (MavenProject)templateProperties.get("project");
            this.siteSourcesType = (String)this.mavenProject.getProperties().get("siteSourcesType");
            String scm = this.mavenProject.getScm().getDeveloperConnection();
            String scmURL = scm.substring(8);
            String scmwebeditorUrl = (String)this.mavenProject.getProperties().get("scmwebeditorUrl");
            this.scmwebeditorPrefixURL = scmwebeditorUrl + "?address=" + scmURL + '/';
            this.getLogger().info("SCMWebeditor prefix url = " + this.scmwebeditorPrefixURL);
            String editFile = "src/site/site_" + this.locale + ".xml";
            this.siteXmlScmwebeditorURL = this.scmwebeditorPrefixURL + editFile;
            this.getLogger().debug("[" + editFile + "] scmwebeditor url = " + this.siteXmlScmwebeditorURL);
        }
        super.render(documents, siteRenderingContext, outputDirectory);
    }

    public void generateDocument(Writer writer, SiteRendererSink sink, SiteRenderingContext siteRenderingContext) throws RendererException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Will generate document " + sink.getRenderingContext().getOutputName());
        }
        Context context = this.createContext(sink, siteRenderingContext);
        this.writeTemplate(writer, context, siteRenderingContext);
    }

    protected Context createContext(SiteRendererSink sink, SiteRenderingContext siteRenderingContext) {
        Method m = this.getCreateContextMethod();
        VelocityContext context = (VelocityContext)ReflectUtil.invokeMethod(m, (Object)this, sink, siteRenderingContext);
        if (this.scmwebeditorEnabled) {
            ScmwebeditorUtils tool = new ScmwebeditorUtils(context, this.getLogger());
            tool.setLocale(this.locale);
            tool.setLocales(this.locales);
            tool.setMavenProject(this.mavenProject);
            tool.setScmwebeditorPrefixURL(this.scmwebeditorPrefixURL);
            tool.setSiteSourcesType(this.siteSourcesType);
            tool.setSiteXmlScmwebeditorURL(this.siteXmlScmwebeditorURL);
            tool.buildStates();
            context.put("ScmwebeditorUtils", (Object)tool);
        }
        return context;
    }

    protected void writeTemplate(Writer writer, Context context, SiteRenderingContext siteContext) throws RendererException {
        Method m = this.getWriteTemplateMethod();
        ReflectUtil.invokeMethod(m, (Object)this, writer, context, siteContext);
    }
}

