/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.plexus.util.IOUtil;
import org.junit.Assert;
import org.nuiton.license.License;
import org.nuiton.util.PluginHelper;

public abstract class BaseLicenseTestCase
extends Assert {
    protected static final String encoding = "utf-8";

    protected File getBaseDir() {
        String path = System.getenv("basedir");
        if (path == null) {
            path = new File("").getAbsolutePath();
        }
        return new File(path);
    }

    protected void assertLicenseFound(String name, License license) throws IOException {
        BaseLicenseTestCase.assertNotNull((Object)license);
        BaseLicenseTestCase.assertEquals((Object)name, (Object)license.getName());
        BaseLicenseTestCase.assertNotNull((Object)license.getLicenseContent(encoding));
        BaseLicenseTestCase.assertNotNull((Object)license.getHeaderContent(encoding));
    }

    protected File createLicenseRepository(boolean createLicene) throws IOException {
        long timestamp = System.currentTimeMillis();
        File repo = new File(this.getBaseDir(), "target" + File.separator + "licenses_" + timestamp);
        if (createLicene) {
            String licenseName = "dummy_" + timestamp;
            this.addLicenseToRepository(repo, licenseName);
        }
        return repo;
    }

    protected void addLicenseToRepository(File repo, String licenseName) throws IOException {
        File defFile = new File(repo, "licenses.properties");
        String content = "";
        if (defFile.exists()) {
            content = IOUtil.toString((InputStream)new FileInputStream(defFile), (String)encoding) + "\n";
        }
        PluginHelper.write((File)defFile, (String)(content + licenseName + "=My dummy license\n"), (String)encoding);
        File file = new File(repo, licenseName);
        file.mkdirs();
        PluginHelper.write((File)new File(file, "license.txt"), (String)("license:" + licenseName), (String)encoding);
        PluginHelper.write((File)new File(file, "header.txt"), (String)("header:" + licenseName), (String)encoding);
    }
}

