/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.model;

import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.model.IssueCategory;
import org.nuiton.jredmine.model.IssuePriority;
import org.nuiton.jredmine.model.IssueStatus;
import org.nuiton.jredmine.model.News;
import org.nuiton.jredmine.model.Project;
import org.nuiton.jredmine.model.RedmineModelScope;
import org.nuiton.jredmine.model.TimeEntry;
import org.nuiton.jredmine.model.Tracker;
import org.nuiton.jredmine.model.User;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.rest.RedmineRestClient;

public enum RedmineModelEnum {
    issueStatus(IssueStatus.class, RedmineModelScope.none, RedmineRestClient.GET_ISSUE_STATUS_LIST),
    issuePriority(IssuePriority.class, RedmineModelScope.none, RedmineRestClient.GET_ISSUE_PRIORITY_LIST),
    project(Project.class, RedmineModelScope.none, RedmineRestClient.GET_PROJECT_LIST),
    issueCategory(IssueCategory.class, RedmineModelScope.project, RedmineRestClient.GET_ISSUE_CATEGORY_LIST),
    tracker(Tracker.class, RedmineModelScope.project, RedmineRestClient.GET_TRACKER_LIST),
    user(User.class, RedmineModelScope.project, RedmineRestClient.GET_USER_LIST),
    news(News.class, RedmineModelScope.project, RedmineRestClient.GET_NEWS_LIST),
    version(Version.class, RedmineModelScope.project, RedmineRestClient.GET_VERSION_LIST),
    issue(Issue.class, RedmineModelScope.version, RedmineRestClient.GET_ISSUE_LIST),
    timeEntry(TimeEntry.class, RedmineModelScope.issue, RedmineRestClient.GET_ISSUE_TIME_ENTRY_LIST),
    attachment(Attachment.class, RedmineModelScope.version, RedmineRestClient.GET_ATTACHMENTS_LIST);

    private final Class<?> modelType;
    private final RedmineModelScope scope;
    private final String requestAll;

    private RedmineModelEnum(Class<?> modelType, RedmineModelScope scope, String requestAll) {
        this.modelType = modelType;
        this.scope = scope;
        this.requestAll = requestAll;
    }

    public Class<?> getModelType() {
        return this.modelType;
    }

    public RedmineModelScope getScope() {
        return this.scope;
    }

    public String getRequestAll() {
        return this.requestAll;
    }

    public static RedmineModelEnum valueOf(Class<?> type) {
        for (RedmineModelEnum e : RedmineModelEnum.values()) {
            if (!e.getModelType().equals(type)) continue;
            return e;
        }
        return null;
    }

    public static RedmineModelEnum safeValueOf(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("klass parameter can not be null");
        }
        RedmineModelEnum r = RedmineModelEnum.valueOf(type);
        if (r == null) {
            throw new IllegalArgumentException("the type " + type.getName() + " is not allowed!");
        }
        return r;
    }
}

