/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.io.rest.RestClient;
import org.nuiton.io.rest.RestClientConfiguration;
import org.nuiton.jredmine.DefaultRedmineServiceTest;
import org.nuiton.jredmine.RedmineAnonymousService;
import org.nuiton.jredmine.RedmineServiceImplementor;
import org.nuiton.jredmine.RedmineTestContract;
import org.nuiton.jredmine.TestHelper;
import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.model.IssueCategory;
import org.nuiton.jredmine.model.IssuePriority;
import org.nuiton.jredmine.model.IssueStatus;
import org.nuiton.jredmine.model.News;
import org.nuiton.jredmine.model.Project;
import org.nuiton.jredmine.model.TimeEntry;
import org.nuiton.jredmine.model.Tracker;
import org.nuiton.jredmine.model.User;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.rest.RedmineRestClient;

public abstract class AbstractRedmineServiceTest<S extends RedmineAnonymousService>
implements RedmineTestContract {
    private static final Log log = LogFactory.getLog(AbstractRedmineServiceTest.class);
    static RedmineRestClient client;
    private S service;
    protected Project[] projects;
    protected Project project;
    protected Version[] versions;
    protected Version version;
    protected User[] users;
    protected Issue[] issues;
    protected IssuePriority[] issuePriorities;
    protected IssueStatus[] issueStatuses;
    protected IssueCategory[] issueCategories;
    protected Tracker[] trackers;
    protected News newz;
    protected News[] news;
    protected Attachment attachment;
    protected Attachment[] attachments;
    protected TimeEntry timeEntry;
    protected TimeEntry[] timeEntries;
    private final Class<S> serviceType;

    public AbstractRedmineServiceTest(Class<S> serviceType) {
        this.serviceType = serviceType;
    }

    protected S getService() {
        return this.service;
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
        client = null;
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (client != null) {
            client.close();
            client = null;
        }
    }

    protected final S newService() throws Exception {
        return (S)((RedmineAnonymousService)this.serviceType.newInstance());
    }

    protected RedmineRestClient newClient(RestClientConfiguration configuration) {
        RedmineRestClient client;
        try {
            client = new RedmineRestClient(configuration);
            client.open();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("can not connect to server " + configuration.getRestUrl() + ", will skip test " + DefaultRedmineServiceTest.class.getName()));
            }
            client = null;
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() throws Exception {
        if (client == null) {
            RestClientConfiguration configuration = TestHelper.getTestConfiguration();
            try {
                client = this.newClient(configuration);
            }
            catch (Throwable throwable) {
                Assume.assumeTrue((client != null && client.isOpen() ? 1 : 0) != 0);
                throw throwable;
            }
            Assume.assumeTrue((client != null && client.isOpen() ? 1 : 0) != 0);
        }
        this.service = this.newService();
        ((RedmineServiceImplementor)this.service).init((RestClient)client);
    }

    @After
    public void tearDown() throws Exception {
        this.service = null;
        this.project = null;
        this.projects = null;
        this.version = null;
        this.versions = null;
        this.users = null;
        this.issues = null;
        this.issueCategories = null;
        this.issuePriorities = null;
        this.issueStatuses = null;
        this.trackers = null;
        this.newz = null;
        this.news = null;
        this.attachment = null;
        this.attachments = null;
        this.timeEntry = null;
        this.timeEntries = null;
    }

    @Test
    public void isInit() throws Exception {
        Assert.assertFalse((boolean)((RedmineServiceImplementor)this.newService()).isInit());
    }

    @Override
    @Test
    public void getProjects() throws Exception {
        this.projects = this.getService().getProjects();
    }

    @Override
    @Test
    public void getIssuePriorities() throws Exception {
        this.issuePriorities = this.getService().getIssuePriorities();
    }

    @Override
    @Test
    public void getIssueStatuses() throws Exception {
        this.issueStatuses = this.getService().getIssueStatuses();
    }

    @Override
    @Test
    public void getProject() throws Exception {
        this.project = this.getService().getProject("one");
    }

    @Override
    @Test
    public void getIssueCategories() throws Exception {
        this.issueCategories = this.getService().getIssueCategories("one");
    }

    @Override
    @Test
    public void getTrackers() throws Exception {
        this.trackers = this.getService().getTrackers("one");
    }

    @Override
    @Test
    public void getNews() throws Exception {
        this.news = this.getService().getNews("one");
    }

    @Override
    @Test
    public void getProjectMembers() throws Exception {
        this.users = this.getService().getProjectMembers("one");
    }

    @Override
    @Test
    public void getProjectIssues() throws Exception {
        this.issues = this.getService().getIssues("one");
    }

    @Override
    @Test
    public void getVersions() throws Exception {
        this.versions = this.getService().getVersions("one");
    }

    @Override
    @Test
    public void getVersion() throws Exception {
        this.version = this.getService().getVersion("one", "1.0.0");
    }

    @Override
    @Test
    public void getVersionIssues() throws Exception {
        this.issues = this.getService().getIssues("one", "1.0.0");
    }

    @Override
    @Test
    public void getOpenedIssues() throws Exception {
        this.issues = this.getService().getOpenedIssues("one");
    }

    @Override
    @Test
    public void getClosedIssues() throws Exception {
        this.issues = this.getService().getClosedIssues("one");
    }

    @Override
    @Test
    public void getIssueTimeEntries() throws Exception {
        this.timeEntries = this.getService().getIssueTimeEntries("one", "6");
    }

    @Override
    @Test
    public void getAttachments() throws Exception {
        this.attachments = this.getService().getAttachments("one", "1.0.0");
    }
}

