/*
 * #%L
 * JRedmine :: Client
 * 
 * $Id: RedmineModelEnum.java 211 2011-06-04 17:01:31Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jredmine/tags/jredmine-1.2.1/jredmine-client/src/main/java/org/nuiton/jredmine/model/RedmineModelEnum.java $
 * %%
 * Copyright (C) 2009 - 2010 Tony Chemit, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.jredmine.model;

import org.nuiton.jredmine.rest.RedmineRestClient;

/**
 * Un énumération pour connaitre l'ensemble des classes du modèle.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0.0
 */
public enum RedmineModelEnum {

    issueStatus(IssueStatus.class, RedmineModelScope.none, RedmineRestClient.GET_ISSUE_STATUS_LIST),
    issuePriority(IssuePriority.class, RedmineModelScope.none, RedmineRestClient.GET_ISSUE_PRIORITY_LIST),
    project(Project.class, RedmineModelScope.none, RedmineRestClient.GET_PROJECT_LIST),
    issueCategory(IssueCategory.class, RedmineModelScope.project, RedmineRestClient.GET_ISSUE_CATEGORY_LIST),
    tracker(Tracker.class, RedmineModelScope.project, RedmineRestClient.GET_TRACKER_LIST),
    user(User.class, RedmineModelScope.project, RedmineRestClient.GET_USER_LIST),
    news(News.class, RedmineModelScope.project, RedmineRestClient.GET_NEWS_LIST),
    version(Version.class, RedmineModelScope.project, RedmineRestClient.GET_VERSION_LIST),
    issue(Issue.class, RedmineModelScope.version, RedmineRestClient.GET_ISSUE_LIST),
    timeEntry(TimeEntry.class, RedmineModelScope.issue, RedmineRestClient.GET_ISSUE_TIME_ENTRY_LIST),
    attachment(Attachment.class, RedmineModelScope.version, RedmineRestClient.GET_ATTACHMENTS_LIST);

    private final Class<?> modelType;

    private final RedmineModelScope scope;

    private final String requestAll;

    RedmineModelEnum(Class<?> modelType, RedmineModelScope scope, String requestAll) {
        this.modelType = modelType;
        this.scope = scope;
        this.requestAll = requestAll;
    }


    public Class<?> getModelType() {
        return modelType;
    }

    public RedmineModelScope getScope() {
        return scope;
    }

    public String getRequestAll() {
        return requestAll;
    }

    public static RedmineModelEnum valueOf(Class<?> type) {
        for (RedmineModelEnum e : values()) {
            if (e.getModelType().equals(type)) {
                return e;
            }
        }
        return null;
    }

    public static RedmineModelEnum safeValueOf(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("klass parameter can not be null");
        }

        // check dataType is authorized

        RedmineModelEnum r = valueOf(type);
        if (r == null) {
            throw new IllegalArgumentException("the type " + type.getName() + " is not allowed!");
        }

        return r;
    }
}
