/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jpa.templates;

import java.util.List;
import javax.persistence.EntityManager;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.jpa.api.AbstractJpaPersistenceContext;
import org.nuiton.jpa.api.DefaultJpaEntityIdFactory;
import org.nuiton.jpa.api.JpaEntityIdFactory;
import org.nuiton.jpa.templates.AbstractJpaTransformer;
import org.nuiton.jpa.templates.JpaTemplatesGeneratorUtil;

public class JpaPersistenceContextTransformer
extends AbstractJpaTransformer {
    public void transformFromModel(ObjectModel model) {
        String packageName = JpaTemplatesGeneratorUtil.getPersistenceContextPackage(this, model);
        String entityAbstractName = JpaTemplatesGeneratorUtil.getPersistenceContextAbstractName(model);
        String entityConcreteName = JpaTemplatesGeneratorUtil.getPersistenceContextConcreteName(model);
        boolean generateAbstract = !this.isInClassPath(packageName, entityAbstractName);
        boolean generateConcrete = !this.isInClassPath(packageName, entityConcreteName);
        boolean useIdGenerator = JpaTemplatesGeneratorUtil.useIdFactory((ObjectModel)this.getModel());
        if (generateAbstract) {
            this.generateAbstract(packageName, entityAbstractName, useIdGenerator);
        }
        if (generateConcrete) {
            this.generateImpl(packageName, entityAbstractName, entityConcreteName, useIdGenerator);
        }
    }

    protected void generateAbstract(String packageName, String className, boolean useIdGenerator) {
        String superClass = JpaTemplatesGeneratorUtil.getPersistenceContextSuperClassTagValue((ObjectModel)this.model);
        if (superClass == null) {
            superClass = AbstractJpaPersistenceContext.class.getName();
        }
        ObjectModelClass output = this.createAbstractClass(className, packageName);
        this.setSuperClass(output, superClass);
        String contractName = JpaTemplatesGeneratorUtil.getPersistenceContextInterfaceName((ObjectModel)this.model);
        boolean addPersistenceContextContract = this.isInClassPath(packageName, contractName);
        if (addPersistenceContextContract) {
            this.addInterface((ObjectModelClassifier)output, packageName + "." + contractName);
        }
        if (useIdGenerator) {
            this.addImport((ObjectModelClassifier)output, DefaultJpaEntityIdFactory.class);
            ObjectModelOperation constructor = this.addConstructor(output, (ObjectModelModifier)ObjectModelJavaModifier.PUBLIC);
            this.addParameter(constructor, EntityManager.class, "entityManager");
            this.setOperationBody(constructor, "\n        super(new DefaultJpaEntityIdFactory(), entityManager);\n    ");
            this.addConstructorWithIdGeneratorAndEntityManager(output);
        } else {
            this.addConstructorWithEntityManager(output);
        }
        List<ObjectModelClass> entityClasses = JpaTemplatesGeneratorUtil.getEntityClasses((ObjectModel)this.getModel(), true);
        for (ObjectModelClass aClass : entityClasses) {
            String daoPackageName = JpaTemplatesGeneratorUtil.getDaoPackage(this, (ObjectModel)this.model, (ObjectModelClassifier)aClass);
            String daoConcreteName = JpaTemplatesGeneratorUtil.getDaoConcreteName(aClass);
            ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, "get" + aClass.getName() + "Dao", daoPackageName + "." + daoConcreteName, new ObjectModelModifier[0]);
            this.setOperationBody(operation, "\n        return new " + daoConcreteName + "(entityManager);\n" + "    ");
        }
    }

    protected ObjectModelClass generateImpl(String packageName, String entityAbstractName, String entityConcreteName, boolean useIdGenerator) {
        ObjectModelClass output = this.createClass(entityConcreteName, packageName);
        this.setSuperClass(output, entityAbstractName);
        if (useIdGenerator) {
            this.addConstructorWithIdGeneratorAndEntityManager(output);
        }
        this.addConstructorWithEntityManager(output);
        return output;
    }

    protected void addConstructorWithIdGeneratorAndEntityManager(ObjectModelClass output) {
        ObjectModelOperation constructor = this.addConstructor(output, (ObjectModelModifier)ObjectModelJavaModifier.PUBLIC);
        this.addParameter(constructor, JpaEntityIdFactory.class, "jpaEntityIdFactory");
        this.addParameter(constructor, EntityManager.class, "entityManager");
        this.setOperationBody(constructor, "\n        super(jpaEntityIdFactory, entityManager);\n    ");
    }
}

