package jaxx.runtime.swing;

import jaxx.runtime.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import jaxx.runtime.Util;
import jaxx.runtime.SwingUtil;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import static org.nuiton.i18n.I18n.n_;
import jaxx.runtime.decorator.JXPathDecorator;
import jaxx.runtime.DataBindingListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EntityComboBox<O> extends jaxx.runtime.swing.Table implements jaxx.runtime.JAXXObject {
    public static final String PROPERTY_AUTO_COMPLETE = "autoComplete";
    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_DATA = "data";
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_I18N_PREFIX = "i18nPrefix";
    public static final String PROPERTY_INDEX = "index";
    public static final String PROPERTY_NOT_SELECTED_TOOL_TIP_TEXT = "notSelectedToolTipText";
    public static final String PROPERTY_POPUP_TITLE_TEXT = "popupTitleText";
    public static final String PROPERTY_PROPERTY = "property";
    public static final String PROPERTY_SELECTED_ITEM = "selectedItem";
    public static final String PROPERTY_SELECTED_TOOL_TIP_TEXT = "selectedToolTipText";
    public static final String PROPERTY_SHOW_DECORATOR = "showDecorator";
    public static final String PROPERTY_SHOW_RESET = "showReset";
    public static final Log log = LogFactory.getLog(jaxx.runtime.swing.EntityComboBox.class);
    private static String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWvXMbRRRfC8uK/JUEJ8YJYcYkKlJJOFAw2BMS25jYI4OJlEkmomBP9yxtON8uu3vxmQIo+APyJ4Sehpl0VAwFNQUNw7/AMBS0DG/3JK1OnK2bSIU+3sfv/d7bt7/T93+SopLkzSc0jqsyCjU7gure3UePPvaeQFtvg2pLJjSXJHlNFUihReb8gV1pcqNVN+m1Xnptix8JHkI4lL1eJ7NKnwSgugBakzfSGW2lao2Bez0WkeyjDkhloT7/+6/CM/+b7wqExALZrWArq+OyXCfTdVJgviavYqWntBbQsIM0JAs7yHfB2LYCqtRH9Ai+IF+RUp3MCCoRTJPr+Vu2GDY/FpqUKk3qBfCWHpm5Osay1Q/whz5BNI9v8lgImzejyTyNNDdFAtCgyUXDrWr4Vjc5D4CGLrSsuvz4PijQxrDoHAvGsQ1tLinSG3GeA59pQ2zULiQXIPWJJhdc0WRILmraQwqpiGR9hhpQEKAB/F0NR8Z21fmKLPQhTnW1G2rogByq4FNNNVm0IZFmQbXO1BB+yWIAbuP1jLGahd6MtObhh5JHYiitS0M/wP7IzbGncS8JdclL/Z6aeAZNJprYhHG95kKWQ64bY6MWBReRaDIdQIZ3lq29Gx5IOGTxiKdo87CKmUrc7/XAGPchjIYgbGCdehDgtqeirdGErbmzquw1ABfdrMnaKPrAk86ZreyZ/japvKXJpVRGz24Cy25LK3vJgbyNc0yFJ2YT9p7bwrY5A4/jklxOBffPJg3uyLxjLBtp7/k2HnoHBjdBkysjfDudAByNLYGq8npqPVCvqk6vnKBMtUhRRoFZw5XW/yXuProScVsZETcDaL3/Li/99uMfL3b6inYJa1/ODB0SZFSa3jVlpvT5RM7MLantU7HeQk2wO2jV+loGsUbPjeSw3kV3ye5R1UWIYun3n35e/uzXV0hhh8wGnPo71MTvkrLuSpwCD/xYvH/HMpo/PofvFww3XO1IwdDi4/ZtsDBgIaxSjSLiRRpuxziQaxkDGbDyyr/8s9T44U5/KFNI8sqp4W4wxcdkJqlmhb6n4ZnCPicURD53Wp2l3lPms9KXj337/klW1zMel75RlcUNo1urHqoT7hZ2alIe2BbMt4cW8VYOxIUE8YAyVEbbSTMbbD0HWPkQj3Cg9hMAlZ4yxXown748zDRrJ1ftFIzbeahAaBryJ4SZP+TtSI0fcx6sssUaM+Y8QHM6/eiYACr1nD9lTnfH4hhzNBFCxj+CidjQM+aynQvhcGKEz8/oIh+COANhJxfCl2d0kQ/h64kRvh2D8B+sM0updAwAAA==";
    private static final long serialVersionUID = 1L;
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected java.util.Map<?,?> $previousValues = new java.util.HashMap<Object,Object>();
    protected java.lang.Boolean autoComplete;
    protected java.lang.Object bean;
    protected javax.swing.JToggleButton changeDecorator;
    protected javax.swing.JComboBox combobox;
    protected java.util.List< O > data;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();
    protected java.lang.Boolean editable;
    protected jaxx.runtime.swing.EntityComboBoxHandler< O > handler;
    protected java.lang.String i18nPrefix;
    protected java.lang.Integer index;
    protected jaxx.runtime.swing.JAXXButtonGroup indexes;
    protected java.lang.String notSelectedToolTipText;
    protected javax.swing.JPopupMenu popup;
    protected javax.swing.JLabel popupLabel;
    protected java.lang.String popupTitleText;
    protected java.lang.String property;
    protected java.lang.Object selectedItem;
    protected java.lang.String selectedToolTipText;
    protected java.lang.Boolean showDecorator;
    protected java.lang.Boolean showReset;
    private javax.swing.JButton $JButton3;
    private javax.swing.JSeparator $JSeparator1;
    private javax.swing.JToolBar $JToolBar2;
    private javax.swing.JToolBar $JToolBar4;
    private EntityComboBox $Table0 = this;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    private PropertyChangeListener $DataSource10 = new DataBindingListener(this, "combobox.enabled");
    private PropertyChangeListener $DataSource11 = new DataBindingListener(this, "combobox.selectedItem");
    private PropertyChangeListener $DataSource12 = new DataBindingListener(this, "$JToolBar4.visible");
    private PropertyChangeListener $DataSource6 = new DataBindingListener(this, "$JToolBar2.visible");
    private PropertyChangeListener $DataSource8 = new DataBindingListener(this, "$JButton3.enabled");
    private PropertyChangeListener $DataSource9 = new DataBindingListener(this, "combobox.editable");

    /* begin raw body code */
    public static final String DEFAULT_POPUP_LABEL = n_("entitycombobox.popup.label");
    public static final String DEFAULT_SELECTED_TOOLTIP = n_("entitycombobox.sort.on");
    public static final String DEFAULT_NOT_SELECTED_TOOLTIP = n_("entitycombobox.sort.off");
    
    
    public void init(JXPathDecorator<O> decorator, java.util.List<O> data) {
        handler.init(decorator, data);
    }
    
    protected void hidePopup() {
        if (popup.isVisible()) {
            popup.setVisible(false);
        }
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public EntityComboBox() {
        $initialize();
    }

    public EntityComboBox(jaxx.runtime.JAXXContext parentContext) {
        jaxx.runtime.Util.initContext(this, parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ("$JToolBar2.visible".equals($binding)) {    
            addPropertyChangeListener("showReset", $DataSource6);
        } else if ("$JButton3.enabled".equals($binding)) {    
            addPropertyChangeListener("enabled", $DataSource8);
        } else if ("combobox.editable".equals($binding)) {    
            addPropertyChangeListener("editable", $DataSource9);
        } else if ("combobox.enabled".equals($binding)) {    
            addPropertyChangeListener("enabled", $DataSource10);
        } else if ("combobox.selectedItem".equals($binding)) {    
            addPropertyChangeListener("selectedItem", $DataSource11);
        } else if ("$JToolBar4.visible".equals($binding)) {    
            addPropertyChangeListener("showDecorator", $DataSource12);
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$JToolBar2.visible".equals($dest)) {
                $JToolBar2.setVisible(isShowReset());
            } else if ("$JButton3.enabled".equals($dest)) {
                $JButton3.setEnabled(isEnabled());
            } else if ("combobox.editable".equals($dest)) {
                combobox.setEditable(isEditable());
            } else if ("combobox.enabled".equals($dest)) {
                combobox.setEnabled(isEnabled());
            } else if ("combobox.selectedItem".equals($dest)) {
                combobox.setSelectedItem(getSelectedItem());
            } else if ("$JToolBar4.visible".equals($dest)) {
                $JToolBar4.setVisible(isShowDecorator());
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ("$JToolBar2.visible".equals($binding)) {    
            removePropertyChangeListener("showReset", $DataSource6);
        } else if ("$JButton3.enabled".equals($binding)) {    
            removePropertyChangeListener("enabled", $DataSource8);
        } else if ("combobox.editable".equals($binding)) {    
            removePropertyChangeListener("editable", $DataSource9);
        } else if ("combobox.enabled".equals($binding)) {    
            removePropertyChangeListener("enabled", $DataSource10);
        } else if ("combobox.selectedItem".equals($binding)) {    
            removePropertyChangeListener("selectedItem", $DataSource11);
        } else if ("$JToolBar4.visible".equals($binding)) {    
            removePropertyChangeListener("showDecorator", $DataSource12);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return Util.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return Util.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton3(java.awt.event.ActionEvent event) {
        setSelectedItem(null);
    }

    public void doActionPerformed__on__changeDecorator(java.awt.event.ActionEvent event) {
        getHandler().togglePopup();
    }

    public void doFocusGained__on__$Table0(java.awt.event.FocusEvent event) {
        combobox.requestFocus();
    }

    public void doFocusGained__on__combobox(java.awt.event.FocusEvent event) {
        hidePopup();
    }

    public void doFocusLost__on__$Table0(java.awt.event.FocusEvent event) {
        hidePopup();
    }

    public void doItemStateChanged__on__combobox(java.awt.event.ItemEvent event) {
        setSelectedItem(combobox.getSelectedItem());
    }

    public void doPopupMenuCanceled__on__popup(javax.swing.event.PopupMenuEvent event) {
        getChangeDecorator().setSelected(false);
    }

    public void doPopupMenuWillBecomeInvisible__on__popup(javax.swing.event.PopupMenuEvent event) {
        getChangeDecorator().setSelected(false);
    }

    public void doStateChanged__on__indexes(javax.swing.event.ChangeEvent event) {
        setIndex((Integer)indexes.getSelectedValue());
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public java.lang.Boolean getAutoComplete() {
        return autoComplete;
    }

    public java.lang.Object getBean() {
        return bean;
    }

    public javax.swing.JToggleButton getChangeDecorator() {
        return changeDecorator;
    }

    public javax.swing.JComboBox getCombobox() {
        return combobox;
    }

    public java.util.List< O > getData() {
        return data;
    }

    public java.lang.Boolean getEditable() {
        return editable;
    }

    public jaxx.runtime.swing.EntityComboBoxHandler< O > getHandler() {
        return handler;
    }

    public java.lang.String getI18nPrefix() {
        return i18nPrefix;
    }

    public java.lang.Integer getIndex() {
        return index;
    }

    public jaxx.runtime.swing.JAXXButtonGroup getIndexes() {
        return indexes;
    }

    public java.lang.String getNotSelectedToolTipText() {
        return notSelectedToolTipText;
    }

    public javax.swing.JPopupMenu getPopup() {
        return popup;
    }

    public javax.swing.JLabel getPopupLabel() {
        return popupLabel;
    }

    public java.lang.String getPopupTitleText() {
        return popupTitleText;
    }

    public java.lang.String getProperty() {
        return property;
    }

    public java.lang.Object getSelectedItem() {
        return selectedItem;
    }

    public java.lang.String getSelectedToolTipText() {
        return selectedToolTipText;
    }

    public java.lang.Boolean getShowDecorator() {
        return showDecorator;
    }

    public java.lang.Boolean getShowReset() {
        return showReset;
    }

    public java.lang.Boolean isAutoComplete() {
        return autoComplete !=null && autoComplete;
    }

    public java.lang.Boolean isEditable() {
        return editable !=null && editable;
    }

    public java.lang.Boolean isShowDecorator() {
        return showDecorator !=null && showDecorator;
    }

    public java.lang.Boolean isShowReset() {
        return showReset !=null && showReset;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setAutoComplete(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.autoComplete;
        this.autoComplete = newValue;
        firePropertyChange(PROPERTY_AUTO_COMPLETE, oldValue, newValue);
    }

    public void setBean(java.lang.Object newValue) {
        java.lang.Object oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setData(java.util.List< O > newValue) {
        java.util.List< O > oldValue = this.data;
        this.data = newValue;
        firePropertyChange(PROPERTY_DATA, oldValue, newValue);
    }

    public void setEditable(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.editable;
        this.editable = newValue;
        firePropertyChange(PROPERTY_EDITABLE, oldValue, newValue);
    }

    public void setI18nPrefix(java.lang.String newValue) {
        java.lang.String oldValue = this.i18nPrefix;
        this.i18nPrefix = newValue;
        firePropertyChange(PROPERTY_I18N_PREFIX, oldValue, newValue);
    }

    public void setIndex(java.lang.Integer newValue) {
        java.lang.Integer oldValue = this.index;
        this.index = newValue;
        firePropertyChange(PROPERTY_INDEX, oldValue, newValue);
    }

    public void setNotSelectedToolTipText(java.lang.String newValue) {
        java.lang.String oldValue = this.notSelectedToolTipText;
        this.notSelectedToolTipText = newValue;
        firePropertyChange(PROPERTY_NOT_SELECTED_TOOL_TIP_TEXT, oldValue, newValue);
    }

    public void setPopupTitleText(java.lang.String newValue) {
        java.lang.String oldValue = this.popupTitleText;
        this.popupTitleText = newValue;
        firePropertyChange(PROPERTY_POPUP_TITLE_TEXT, oldValue, newValue);
    }

    public void setProperty(java.lang.String newValue) {
        java.lang.String oldValue = this.property;
        this.property = newValue;
        firePropertyChange(PROPERTY_PROPERTY, oldValue, newValue);
    }

    public void setSelectedItem(java.lang.Object newValue) {
        java.lang.Object oldValue = this.selectedItem;
        this.selectedItem = newValue;
        firePropertyChange(PROPERTY_SELECTED_ITEM, oldValue, newValue);
    }

    public void setSelectedToolTipText(java.lang.String newValue) {
        java.lang.String oldValue = this.selectedToolTipText;
        this.selectedToolTipText = newValue;
        firePropertyChange(PROPERTY_SELECTED_TOOL_TIP_TEXT, oldValue, newValue);
    }

    public void setShowDecorator(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showDecorator;
        this.showDecorator = newValue;
        firePropertyChange(PROPERTY_SHOW_DECORATOR, oldValue, newValue);
    }

    public void setShowReset(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showReset;
        this.showReset = newValue;
        firePropertyChange(PROPERTY_SHOW_RESET, oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected javax.swing.JButton get$JButton3() {
        return $JButton3;
    }

    protected javax.swing.JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    protected javax.swing.JToolBar get$JToolBar2() {
        return $JToolBar2;
    }

    protected javax.swing.JToolBar get$JToolBar4() {
        return $JToolBar4;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $Table0
        add($JToolBar2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        add(combobox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        add($JToolBar4, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToPopup();
        // inline complete setup of $JToolBar2
        $JToolBar2.add($JButton3);
        // inline complete setup of $JToolBar4
        $JToolBar4.add(changeDecorator);
        // init data bindings
        popup.setBorder(new TitledBorder(_("entitycombobox.popup.title")));
        applyDataBinding("$JToolBar2.visible");
        $JButton3.setIcon(jaxx.runtime.Util.createActionIcon("combobox-reset"));
        applyDataBinding("$JButton3.enabled");
        applyDataBinding("combobox.editable");
        applyDataBinding("combobox.enabled");
        applyDataBinding("combobox.selectedItem");
        applyDataBinding("$JToolBar4.visible");
        changeDecorator.setIcon(jaxx.runtime.Util.createActionIcon("combobox-sort"));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$Table0", this);
        createAutoComplete();
        createShowReset();
        createShowDecorator();
        createEditable();
        createProperty();
        createBean();
        createSelectedItem();
        createIndex();
        createData();
        createIndexes();
        createHandler();
        createSelectedToolTipText();
        createNotSelectedToolTipText();
        createPopupTitleText();
        createI18nPrefix();
        createPopup();
        createPopupLabel();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new javax.swing.JSeparator());
        $JSeparator1.setName("$JSeparator1");
        // inline creation of $JToolBar2
        $objectMap.put("$JToolBar2", $JToolBar2 = new javax.swing.JToolBar());
        $JToolBar2.setName("$JToolBar2");
        $JToolBar2.setBorderPainted(false);
        $JToolBar2.setFloatable(false);
        // inline creation of $JButton3
        $objectMap.put("$JButton3", $JButton3 = new javax.swing.JButton());
        $JButton3.setName("$JButton3");
        $JButton3.setFocusPainted(false);
        $JButton3.setFocusable(false);
        $JButton3.setToolTipText(_("entitycombobox.action.reset.tip"));
        $JButton3.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton3"));
        createCombobox();
        // inline creation of $JToolBar4
        $objectMap.put("$JToolBar4", $JToolBar4 = new javax.swing.JToolBar());
        $JToolBar4.setName("$JToolBar4");
        $JToolBar4.setBorderPainted(false);
        $JToolBar4.setFloatable(false);
        createChangeDecorator();
        // inline creation of $Table0
        setName("$Table0");
        $Table0.addFocusListener(Util.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__$Table0"));
        $Table0.addFocusListener(Util.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__$Table0"));
        
        $completeSetup();
    }

    protected void addChildrenToPopup() {
        if (!allComponentsCreated) {
            return;
        }
        popup.add(popupLabel);
        popup.add($JSeparator1);
    }

    protected void createAutoComplete() {
        $objectMap.put("autoComplete", autoComplete = false);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createChangeDecorator() {
        $objectMap.put("changeDecorator", changeDecorator = new javax.swing.JToggleButton());
        changeDecorator.setName("changeDecorator");
        changeDecorator.setFocusPainted(false);
        changeDecorator.setFocusable(false);
        changeDecorator.setToolTipText(_("entitycombobox.action.sort.tip"));
        changeDecorator.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__changeDecorator"));
    }

    protected void createCombobox() {
        $objectMap.put("combobox", combobox = new javax.swing.JComboBox());
        combobox.setName("combobox");
        combobox.addFocusListener(Util.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__combobox"));
        combobox.addItemListener(Util.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__combobox"));
    }

    protected void createData() {
        $objectMap.put("data", data = null);
    }

    protected void createEditable() {
        $objectMap.put("editable", editable = true);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new jaxx.runtime.swing.EntityComboBoxHandler< O >(this));
    }

    protected void createI18nPrefix() {
        $objectMap.put("i18nPrefix", i18nPrefix = "entitycombobox.common.");
    }

    protected void createIndex() {
        $objectMap.put("index", index = 0);
    }

    protected void createIndexes() {
        $objectMap.put("indexes", indexes = new jaxx.runtime.swing.JAXXButtonGroup());
        indexes.setUseToolTipText(true);
        indexes.addChangeListener(Util.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__indexes"));
    }

    protected void createNotSelectedToolTipText() {
        $objectMap.put("notSelectedToolTipText", notSelectedToolTipText = null);
    }

    protected void createPopup() {
        $objectMap.put("popup", popup = new javax.swing.JPopupMenu());
        popup.setName("popup");
        popup.addPopupMenuListener(Util.getEventListener(PopupMenuListener.class, "popupMenuCanceled", this, "doPopupMenuCanceled__on__popup"));
        popup.addPopupMenuListener(Util.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeInvisible", this, "doPopupMenuWillBecomeInvisible__on__popup"));
    }

    protected void createPopupLabel() {
        $objectMap.put("popupLabel", popupLabel = new javax.swing.JLabel());
        popupLabel.setName("popupLabel");
    }

    protected void createPopupTitleText() {
        $objectMap.put("popupTitleText", popupTitleText = null);
    }

    protected void createProperty() {
        $objectMap.put("property", property = "");
    }

    protected void createSelectedItem() {
        $objectMap.put("selectedItem", selectedItem = null);
    }

    protected void createSelectedToolTipText() {
        $objectMap.put("selectedToolTipText", selectedToolTipText = null);
    }

    protected void createShowDecorator() {
        $objectMap.put("showDecorator", showDecorator = true);
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = false);
    }

}