/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.gis.absolute;

import com.google.common.base.Preconditions;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatterFactory;
import jaxx.runtime.spi.UIHandler;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.gis.DmdCoordinate;
import org.nuiton.jaxx.widgets.gis.DmdCoordinateConverter;
import org.nuiton.jaxx.widgets.gis.MaskFormatterFromConverter;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteDmdCoordinateEditor;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteDmdCoordinateEditorModel;
import org.nuiton.util.beans.BeanUtil;

public class AbsoluteDmdCoordinateEditorHandler
implements UIHandler<AbsoluteDmdCoordinateEditor> {
    private static final Log log = LogFactory.getLog(AbsoluteDmdCoordinateEditorHandler.class);
    private AbsoluteDmdCoordinateEditor ui;
    protected Method signMutator;
    protected Method degreeMutator;
    protected Method minuteMutator;
    protected Method decimalMutator;
    protected boolean valueIsAdjusting;
    protected boolean valueModelIsAdjusting;
    protected DmdCoordinateConverter coordinateConverter;

    public void beforeInit(AbsoluteDmdCoordinateEditor ui) {
        this.ui = ui;
        this.coordinateConverter = new DmdCoordinateConverter();
    }

    public void afterInit(AbsoluteDmdCoordinateEditor ui) {
    }

    public void init(boolean longitudeEditor) {
        MaskFormatterFromConverter<DmdCoordinate> maskFormatter;
        final AbsoluteDmdCoordinateEditorModel model = this.ui.getModel();
        Preconditions.checkNotNull((Object)model.getBean(), (Object)("could not find bean in " + this.ui));
        Preconditions.checkNotNull((Object)model.getPropertyDegree(), (Object)("could not find propertyDegree in " + this.ui));
        Preconditions.checkNotNull((Object)model.getPropertyMinute(), (Object)("could not find propertyMinute in " + this.ui));
        Preconditions.checkNotNull((Object)model.getPropertyDecimal(), (Object)("could not find propertyDecimal in " + this.ui));
        Serializable bean = model.getBean();
        this.degreeMutator = BeanUtil.getMutator((Object)bean, (String)model.getPropertyDegree());
        Preconditions.checkNotNull((Object)this.degreeMutator, (Object)("could not find mutator for " + model.getPropertyDegree()));
        this.minuteMutator = BeanUtil.getMutator((Object)bean, (String)model.getPropertyMinute());
        Preconditions.checkNotNull((Object)this.minuteMutator, (Object)("could not find mutator for " + model.getPropertyMinute()));
        this.decimalMutator = BeanUtil.getMutator((Object)bean, (String)model.getPropertyDecimal());
        Preconditions.checkNotNull((Object)this.decimalMutator, (Object)("could not find mutator for " + model.getPropertyDecimal()));
        this.coordinateConverter.setForLongitude(longitudeEditor);
        String pattern = this.getMaskFormatterPattern(longitudeEditor);
        try {
            maskFormatter = MaskFormatterFromConverter.newFormatter(DmdCoordinate.class, pattern, (Converter)this.coordinateConverter);
            maskFormatter.setValidCharacters(" 01234567890");
            maskFormatter.setCommitsOnValidEdit(true);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        JFormattedTextField editor = this.ui.getEditor();
        DefaultFormatterFactory formatterFactory = new DefaultFormatterFactory(maskFormatter);
        editor.setFormatterFactory(formatterFactory);
        editor.setFocusLostBehavior(0);
        editor.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DmdCoordinate newValue = (DmdCoordinate)((Object)evt.getNewValue());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Value has changed: " + (Object)((Object)newValue)));
                }
                model.setValue(newValue);
            }
        });
        model.addPropertyChangeListener("degree", new ModelPropertyChangeListener(model, this.degreeMutator));
        model.addPropertyChangeListener("minute", new ModelPropertyChangeListener(model, this.minuteMutator));
        model.addPropertyChangeListener("decimal", new ModelPropertyChangeListener(model, this.decimalMutator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(DmdCoordinate value, boolean pushToModel) {
        if (this.valueModelIsAdjusting) {
            return;
        }
        this.valueIsAdjusting = !pushToModel;
        try {
            this.ui.getEditor().setValue((Object)value);
        }
        finally {
            this.valueIsAdjusting = false;
        }
    }

    public void resetEditor() {
        this.setValue(null, true);
    }

    protected String getMaskFormatterPattern(boolean longitudeEditor) {
        String pattern = "**\u00b0**.**''";
        if (longitudeEditor) {
            pattern = "*" + pattern;
        }
        return pattern;
    }

    private class ModelPropertyChangeListener
    implements PropertyChangeListener {
        private final AbsoluteDmdCoordinateEditorModel model;
        private final Method mutator;

        private ModelPropertyChangeListener(AbsoluteDmdCoordinateEditorModel model, Method mutator) {
            this.model = model;
            this.mutator = mutator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!AbsoluteDmdCoordinateEditorHandler.this.valueIsAdjusting) {
                Object newValue = evt.getNewValue();
                try {
                    AbsoluteDmdCoordinateEditorHandler.this.valueModelIsAdjusting = true;
                    try {
                        this.mutator.invoke((Object)this.model.getBean(), newValue);
                    }
                    finally {
                        AbsoluteDmdCoordinateEditorHandler.this.valueModelIsAdjusting = false;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

