/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator.swing;

import java.awt.Component;
import javax.swing.JTable;
import jaxx.runtime.validator.swing.SwingListValidatorDataLocator;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.list.BeanListValidator;

public class SwingListValidatorHighlightPredicate<O>
implements HighlightPredicate {
    protected final NuitonValidatorScope scope;
    protected final BeanListValidator<O> validator;
    protected final SwingListValidatorDataLocator<O> dataLocator;

    public static <O> SwingListValidatorHighlightPredicate<O> newFatalPredicate(BeanListValidator<O> validator, SwingListValidatorDataLocator<O> dataLocator) {
        return SwingListValidatorHighlightPredicate.newPredicate(NuitonValidatorScope.FATAL, validator, dataLocator);
    }

    public static <O> SwingListValidatorHighlightPredicate<O> newErrorPredicate(BeanListValidator<O> validator, SwingListValidatorDataLocator<O> dataLocator) {
        return SwingListValidatorHighlightPredicate.newPredicate(NuitonValidatorScope.ERROR, validator, dataLocator);
    }

    public static <O> SwingListValidatorHighlightPredicate<O> newWarningPredicate(BeanListValidator<O> validator, SwingListValidatorDataLocator<O> dataLocator) {
        return SwingListValidatorHighlightPredicate.newPredicate(NuitonValidatorScope.WARNING, validator, dataLocator);
    }

    public static <O> SwingListValidatorHighlightPredicate<O> newInfoPredicate(BeanListValidator<O> validator, SwingListValidatorDataLocator<O> dataLocator) {
        return SwingListValidatorHighlightPredicate.newPredicate(NuitonValidatorScope.INFO, validator, dataLocator);
    }

    public static <O> SwingListValidatorHighlightPredicate<O> newPredicate(NuitonValidatorScope scope, BeanListValidator<O> validator, SwingListValidatorDataLocator<O> dataLocator) {
        return new SwingListValidatorHighlightPredicate<O>(scope, validator, dataLocator);
    }

    public SwingListValidatorHighlightPredicate(NuitonValidatorScope scope, BeanListValidator<O> validator, SwingListValidatorDataLocator<O> dataLocator) {
        this.scope = scope;
        this.validator = validator;
        this.dataLocator = dataLocator;
    }

    public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
        int columnIndex = adapter.convertColumnIndexToModel(adapter.column);
        String fieldName = adapter.getColumnName(columnIndex);
        int rowIndex = adapter.convertRowIndexToModel(adapter.row);
        JTable component = (JTable)adapter.getComponent();
        O bean = this.dataLocator.locateBean(component.getModel(), rowIndex);
        boolean result = false;
        if (bean != null && this.dataLocator.acceptType(bean.getClass())) {
            BeanListValidator.NuitonValidatorContext context = this.validator.getContext(bean);
            NuitonValidatorScope highestScope = context.getHighestScope(fieldName);
            result = this.scope == highestScope;
        }
        return result;
    }
}

