/*
 * #%L
 * JAXX :: Validator
 * 
 * $Id: BeanValidatorEvent.java 2144 2010-12-30 13:06:21Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.2.5/jaxx-validator/src/main/java/jaxx/runtime/validator/BeanValidatorEvent.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.validator;

import java.util.EventObject;

/**
 * The definition of an event on {@link BeanValidatorListener}
 * to be fired by a {@link BeanValidator}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 * @deprecated since 2.2.4, the code is moved into the org.nuiton:nuiton-validator project, will be removed in version 2.3
 */
@Deprecated
public class BeanValidatorEvent extends EventObject {

    private static final long serialVersionUID = 1L;

    /** the field impacted by the validator */
    protected BeanValidatorField<?> field;

    /** the scope impacted by the event */
    protected BeanValidatorScope scope;

    protected String[] messagestoAdd;

    protected String[] messagestoDelete;

    public BeanValidatorEvent(BeanValidator<?> source,
                              BeanValidatorField<?> field,
                              BeanValidatorScope scope,
                              String[] messagestoAdd,
                              String[] messagestoDelete) {
        super(source);
        this.field = field;
        this.scope = scope;
        this.messagestoAdd = messagestoAdd;
        this.messagestoDelete = messagestoDelete;
    }

    @Override
    public BeanValidator<?> getSource() {
        return (BeanValidator<?>) super.getSource();
    }

    public String getFieldName() {
        return field.getName();
    }

    public String[] getMessagesToAdd() {
        return messagestoAdd;
    }

    public String[] getMessagesToDelete() {
        return messagestoDelete;
    }

    public BeanValidatorScope getScope() {
        return scope;
    }

    public BeanValidatorField<?> getField() {
        return field;
    }
}
