/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator.swing.ui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import jaxx.runtime.validator.BeanValidatorField;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.swing.ui.AbstractBeanValidatorUI;
import org.jdesktop.jxlayer.JXLayer;

public class IconValidationUI
extends AbstractBeanValidatorUI {
    protected static BufferedImage fatalIcon;
    protected static BufferedImage errorIcon;
    protected static BufferedImage warningIcon;
    protected static BufferedImage infoIcon;

    public IconValidationUI(BeanValidatorField<?> field) {
        super(field);
        if (fatalIcon == null) {
            fatalIcon = IconValidationUI.prepareIcon(Color.MAGENTA);
        }
        if (errorIcon == null) {
            errorIcon = IconValidationUI.prepareIcon(Color.RED);
        }
        if (warningIcon == null) {
            warningIcon = IconValidationUI.prepareIcon(Color.ORANGE);
        }
        if (infoIcon == null) {
            infoIcon = IconValidationUI.prepareIcon(Color.GREEN);
        }
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 3));
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.setBorder(null);
    }

    protected void paintLayer(Graphics2D g2, JXLayer<JComponent> l) {
        super.paintLayer(g2, l);
        BeanValidatorScope scope = this.field.getScope();
        if (scope != null) {
            BufferedImage icon = null;
            switch (scope) {
                case FATAL: {
                    icon = fatalIcon;
                    break;
                }
                case ERROR: {
                    icon = errorIcon;
                    break;
                }
                case WARNING: {
                    icon = warningIcon;
                    break;
                }
                case INFO: {
                    icon = infoIcon;
                }
            }
            if (icon != null) {
                g2.drawImage((Image)icon, l.getWidth() - icon.getWidth() - 1, 0, null);
            }
        }
    }

    protected static BufferedImage prepareIcon(Color color) {
        int width = 7;
        int height = 8;
        BufferedImage icon = new BufferedImage(width, height, 2);
        Graphics2D g2 = (Graphics2D)icon.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setColor(color);
        g2.fillRect(0, 0, width, height);
        g2.setColor(Color.WHITE);
        g2.drawLine(0, 0, width, height);
        g2.drawLine(0, height, width, 0);
        g2.dispose();
        return icon;
    }
}

