/*
 * #%L
 * JAXX :: Validator
 * 
 * $Id: ValidatorsMap.java 2144 2010-12-30 13:06:21Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.2.4/jaxx-validator/src/main/java/jaxx/runtime/validator/ValidatorsMap.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.validator;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * Un dictionnaire de validateurs ordonnees par le type de leur bean.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.0.1
 * @deprecated since 2.2.4, the code is moved into the org.nuiton:nuiton-validator project, will be removed in version 2.3
 */
@Deprecated
public class ValidatorsMap implements Map<Class<?>, BeanValidator<?>> {

    protected final Map<Class<?>, BeanValidator<?>> delegate;

    public ValidatorsMap() {
        delegate = new HashMap<Class<?>, BeanValidator<?>>();
    }

    public BeanValidatorScope[] getScopes() {
        EnumSet<BeanValidatorScope> result =
                EnumSet.noneOf(BeanValidatorScope.class);
        for (BeanValidator<?> b : values()) {
            result.addAll(b.getScopes());
        }
        return result.toArray(new BeanValidatorScope[result.size()]);
    }

//    public <X> BeanValidator<X> getValidator(X klass) {
//        BeanValidator<X> beanValidator = (BeanValidator<X>) get(klass.getClass());
//        return beanValidator;
//    }

    public <X> BeanValidator<X> getValidator(Class<X> klass) {
        BeanValidator<X> beanValidator = (BeanValidator<X>) get(klass);
        return beanValidator;
    }

    @Override
    public int size() {
        return delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return delegate.containsValue(value);
    }

    @Override
    public BeanValidator<?> get(Object key) {
        return delegate.get(key);
    }

    @Override
    public BeanValidator<?> put(Class<?> key, BeanValidator<?> value) {
        return delegate.put(key, value);
    }

    @Override
    public BeanValidator<?> remove(Object key) {
        return delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends Class<?>, ? extends BeanValidator<?>> m) {
        delegate.putAll(m);
    }

    @Override
    public void clear() {
        delegate.clear();
    }

    @Override
    public Set<Class<?>> keySet() {
        return delegate.keySet();
    }

    @Override
    public Collection<BeanValidator<?>> values() {
        return delegate.values();
    }

    @Override
    public Set<Entry<Class<?>, BeanValidator<?>>> entrySet() {
        return delegate.entrySet();
    }

}
