/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime;

import java.awt.Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXContextEntryDef;
import jaxx.runtime.JAXXObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultJAXXContext
implements JAXXContext {
    protected static final JAXXContextEntryDef<JAXXContext> PARENT_CONTEXT_ENTRY = JAXXContextEntryDef.newDef(JAXXContext.class);
    private static final Log log = LogFactory.getLog(DefaultJAXXContext.class);
    protected JAXXObject ui;
    protected JAXXContext parentContext;
    protected final Map<JAXXContextEntryDef, Object> data = new HashMap<JAXXContextEntryDef, Object>();

    public DefaultJAXXContext() {
    }

    public DefaultJAXXContext(JAXXObject ui) {
        this();
        this.ui = ui;
    }

    @Override
    public <T> void setContextValue(T o) {
        this.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        if (name == null && PARENT_CONTEXT_ENTRY.accept2(o.getClass(), null)) {
            this.setParentContext((JAXXContext)o);
            return;
        }
        JAXXContextEntryDef<?> entry = this.getKey(name, o.getClass());
        Object oldValue = this.remove0(o.getClass(), name);
        if (oldValue != null && log.isDebugEnabled()) {
            log.debug((Object)("remove value " + oldValue.getClass() + " for " + entry));
        }
        this.data.put(entry, o);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return this.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        if (this.parentContext != null && this.parentContext.getClass() == clazz || PARENT_CONTEXT_ENTRY.accept(clazz, name)) {
            return (T)this.getParentContext();
        }
        for (Map.Entry<JAXXContextEntryDef, Object> entry : this.data.entrySet()) {
            if (!entry.getKey().accept(clazz, name)) continue;
            return (T)entry.getValue();
        }
        if (JAXXContext.class == clazz) {
            return null;
        }
        JAXXContext parent = this.getParentContext();
        if (parent == null) {
            return null;
        }
        return parent.getContextValue(clazz, name);
    }

    @Override
    public <T> void removeContextValue(Class<T> klazz) {
        this.removeContextValue(klazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> klazz, String name) {
        this.remove0(klazz, name);
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return this.getParentContainer(this.ui, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object top, Class<O> clazz) {
        if (this.ui == null) {
            throw new IllegalStateException("no ui attached to this context");
        }
        if (top == null) {
            throw new IllegalArgumentException("top parameter can not be null");
        }
        if (!Container.class.isAssignableFrom(top.getClass())) {
            throw new IllegalArgumentException("top parameter " + top + " is not a " + Container.class);
        }
        Container parent = ((Container)top).getParent();
        if (parent != null && !clazz.isAssignableFrom(parent.getClass())) {
            parent = this.getParentContainer(parent, clazz);
        }
        return (O)parent;
    }

    public String[] getKeys(Class<?> klass) {
        ArrayList<String> keys = new ArrayList<String>();
        for (JAXXContextEntryDef key : this.data.keySet()) {
            if (key.getKlass() != klass) continue;
            keys.add(key.getName());
        }
        return keys.toArray(new String[keys.size()]);
    }

    public void clear() {
        this.data.clear();
    }

    protected JAXXObject getUi() {
        return this.ui;
    }

    protected void setUi(JAXXObject ui) {
        this.ui = ui;
    }

    protected JAXXContextEntryDef<?> getKey(String name, Class<?> klass) {
        return JAXXContextEntryDef.newDef(name, klass);
    }

    protected <T> T remove0(Class<T> klazz, String name) {
        if (PARENT_CONTEXT_ENTRY.accept(klazz, name)) {
            JAXXContext old = this.getParentContext();
            this.setParentContext(null);
            return (T)old;
        }
        JAXXContextEntryDef entry = null;
        for (JAXXContextEntryDef entryDef : this.data.keySet()) {
            if (!entryDef.accept(klazz, name)) continue;
            entry = entryDef;
            break;
        }
        if (entry != null) {
            return (T)this.data.remove(entry);
        }
        if (JAXXContext.class == klazz) {
            return null;
        }
        JAXXContext parent = this.getParentContext();
        if (parent == null) {
            return null;
        }
        if (parent instanceof DefaultJAXXContext) {
            return ((DefaultJAXXContext)parent).remove0(klazz, name);
        }
        return null;
    }

    protected JAXXContext getParentContext() {
        return this.parentContext;
    }

    protected void setParentContext(JAXXContext parentContext) {
        if (parentContext instanceof JAXXObject) {
            parentContext = ((JAXXObject)parentContext).getDelegateContext();
        }
        this.parentContext = parentContext;
    }
}

