/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime;

import java.util.ArrayList;
import java.util.List;
import jaxx.runtime.Decorator;

public class DecoratorUtils {
    protected static List<DecoratorContext<?>> cache;

    public static <T> void registerDecorator(String context, Decorator<T> decorator) {
        DecoratorContext<T> result = DecoratorUtils.getDecoratorContext(decorator.getInternalClass(), context);
        if (result != null) {
            throw new IllegalArgumentException("there is an already register decorator " + result);
        }
        if (cache == null) {
            cache = new ArrayList();
        }
        cache.add(new DecoratorContext<T>(context, decorator));
    }

    public static <T> Decorator<T> getDecorator(String context) {
        Decorator<T> result = DecoratorUtils.getDecorator(null, context);
        return result;
    }

    public static <T> Decorator<T> getDecorator(Class<T> type, String context) {
        DecoratorContext<T> decoratorContext = DecoratorUtils.getDecoratorContext(type, context);
        Decorator<T> result = decoratorContext == null ? null : decoratorContext.getDecorator();
        return result;
    }

    public static void clear() {
        if (cache != null) {
            cache.clear();
        }
    }

    protected static <T> DecoratorContext<T> getDecoratorContext(Class<T> type, String context) {
        DecoratorContext<T> result = null;
        if (cache != null) {
            for (DecoratorContext<T> decoratorContext : cache) {
                if (type == null) {
                    if (!decoratorContext.accept(context)) continue;
                    result = decoratorContext;
                    break;
                }
                if (!decoratorContext.accept(type, context)) continue;
                result = decoratorContext;
                break;
            }
        }
        return result;
    }

    public static class DecoratorContext<T> {
        final String context;
        final Decorator<T> decorator;

        public DecoratorContext(String context, Decorator<T> decorator) {
            this.context = context;
            this.decorator = decorator;
        }

        public String getContext() {
            return this.context;
        }

        public Decorator<T> getDecorator() {
            return this.decorator;
        }

        public Class<T> getType() {
            return this.decorator.getInternalClass();
        }

        public boolean accept(Class<?> type, String context) {
            return this.getType().isAssignableFrom(type) && this.accept(context);
        }

        public boolean accept(String context) {
            return this.context == null && context == null || this.context != null && this.context.equals(context);
        }

        public String toString() {
            return super.toString() + "<type: " + this.getType().getName() + ", context :" + this.context + ">";
        }
    }
}

