/*
 * Decompiled with CFR 0.152.
 */
package jaxx.css;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jaxx.css.Selector;

public class Rule
implements Serializable,
Comparable<Rule> {
    public static final String INLINE_ATTRIBUTE = "<inline attribute>";
    public static final String DATA_BINDING = "<data binding>";
    private Selector[] selectors;
    private Map<String, String> properties;
    private static final long serialVersionUID = 1L;

    public Rule(Selector[] selectors, Map<String, String> properties) {
        this.selectors = selectors;
        Arrays.sort(selectors);
        this.properties = properties;
    }

    public Rule(Selector[] selectors, String[] keys, String[] values) {
        this.selectors = selectors;
        Arrays.sort(selectors);
        this.properties = new HashMap<String, String>();
        if (keys.length != values.length) {
            throw new IllegalArgumentException("keys and values must have the same number of entries");
        }
        for (int i = 0; i < keys.length; ++i) {
            this.properties.put(keys[i], values[i]);
        }
    }

    public Selector[] getSelectors() {
        return this.selectors;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public int compareTo(Rule o) {
        return this.selectors[0].compareTo(o.selectors[0]);
    }

    public String toString() {
        return "Rule[" + Arrays.asList(this.selectors) + ", " + this.properties + "]";
    }
}

