/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.css;

public class Stylesheet implements java.io.Serializable {
    private Rule[] rules;
    private static final long serialVersionUID = 1L;


    public Stylesheet() {
        rules = new Rule[0];
    }

    public Stylesheet(Rule[] rules) {
        this.rules = rules;
        java.util.Arrays.sort(rules);
    }

    public Rule[] getRules() {
        return rules;
    }

    public void add(Rule newRule) {
        Rule[] oldRules = rules;
        rules = new Rule[oldRules.length + 1];
        System.arraycopy(oldRules, 0, rules, 0, oldRules.length);
        rules[rules.length - 1] = newRule;
        java.util.Arrays.sort(rules);
    }

    public void add(Rule[] newRules) {
        Rule[] oldRules = rules;
        rules = new Rule[oldRules.length + newRules.length];
        System.arraycopy(oldRules, 0, rules, 0, oldRules.length);
        System.arraycopy(newRules, 0, rules, oldRules.length, newRules.length);
        java.util.Arrays.sort(rules);
    }

    @Override
    public String toString() {
        return "Stylesheet" + java.util.Arrays.asList(rules);
    }
}