/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.css;

import java.util.Map;

public class Rule implements java.io.Serializable, Comparable<Rule> {
    public static final String INLINE_ATTRIBUTE = "<inline attribute>";
    public static final String DATA_BINDING = "<data binding>";

    private Selector[] selectors;
    private Map<String, String> properties;
    private static final long serialVersionUID = 1L;


    public Rule(Selector[] selectors, Map<String, String> properties) {
        this.selectors = selectors;
        java.util.Arrays.sort(selectors);
        this.properties = properties;
    }


    public Rule(Selector[] selectors, String[] keys, String[] values) {
        this.selectors = selectors;
        java.util.Arrays.sort(selectors);
        this.properties = new java.util.HashMap<String, String>();
        if (keys.length != values.length) {
            throw new IllegalArgumentException("keys and values must have the same number of entries");
        }
        for (int i = 0; i < keys.length; i++) {
            properties.put(keys[i], values[i]);
        }
    }

    public Selector[] getSelectors() {
        return selectors;
    }

    public Map<String, String> getProperties() {
        return properties;
    }

    @Override
    public int compareTo(Rule o) {
        return selectors[0].compareTo(o.selectors[0]); // they are already sorted so we only need to compare the highest-ranked from each one
    }

    @Override
    public String toString() {
        return "Rule[" + java.util.Arrays.asList(selectors) + ", " + properties + "]";
    }
}