package org.nuiton.jaxx.demo.feature.nav.content;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.entities.People;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.swing.editor.bean.BeanListHeader;
import org.nuiton.jaxx.runtime.swing.renderer.DecoratorProviderListCellRenderer;
import static org.nuiton.i18n.I18n.t;

public class ActorsContentUI extends AbstractContentUI<List<People>> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DATA = "data";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_LIST_HEADER_DATA = "listHeader.data";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON2_ENABLED = "$JButton2.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK2Vz08TQRTHp5UC5Yf8qAGJRjEUMRG3gMaQQFB+hACpQgANsRenu1O6ZDqzzs7SxQMHD978Bzx49WL4H4gnEy9e+R9M+BN8s1u6VNplpfYwbWfefOb73rz35ttvlLAFGudiV2OOKTnT9rDrasJh0iwRbW1+Z2c9v0d0uURsXZiW5AL5n1gcxXOo06jO2xJpuSyQMj4po0iZCimzyEsWZ4SdA81kUYctDyixi4RIiR403KzbdmarajnjWo6onFVXdb2zfn6cPImRpc9xhFwL5HeC2w//ARB43ZJFcdOQqD+7h/dxhmK2C+KEyXbBoW41t0ixbb/EJfIOHaK2LGq1sACYRI+uFB4P56FcS6JUej5vS4F1uciZhB2vVickmv7bFYOUuFYgWDqCaAzva7pvrc3r6q6qey3LQ7dK1GJgiSW6rjzQHGlSLWvaMlhvT69tYEYonNavbFzNLoPTmj+rjJJV2+702pYuOKVqDTYM1mwIlpR5T6CAwoES9dUYKxFqvb9q1iY5p3ksJLpRY7kN0wtYXFQ8qf73qeFmdS2ZXltwJIQL1KVqMP60Mrt10dpD3W2wOFVnsUP5tEKwQUSdWzpLOP9oYsCK0PIEM20Bhmx1a0W7QPcbEaBEtKBEgmyN5VBCODAt0Ujj6lQFtglWfmmNNC4tdYxn+OHoUHwtn56c1VMKxA1ftutc64DktgS3ICqm0tbjF5NKu8wLbM3kUNImlOh+XxkLV75VsQT1oKIvSOAVbBeBlmg7Of4+8PbXNRRfhgvh2FjGyn4VJWVRQMQ4NVzr2XNPXFe5HcZeJVOiVooPONwtuj6rqmM4bzIDbmrOhSiNhUepKupo/fTHl0+jx2eRioHGdJSdQbQSb1CryajJiNd7Km2lbq/ptGziGDzoGfW6SEx991qVShn3xom6/ue5qKTfY9dRX088D9Svpx4lFYHSq3PqlJifyq9NUm6SN1TkwnwPHQxTv5VA1W9wauoHTYIH91U+6v8b26UTSjcJA+9DYzkQgZUsQP5KnKdQ5P2zflIMYwnvT96RZK4+eOhSsJqeCpHWPOF2BOfaCFOeGSGYOxEwLZK43puxfVWGmi6EEO5FIuAQP0aa1nA5ofKmh6gYjcDoMCen2YYgBdMNUROF5L3vTapJQrcubxKbhF1wFFC7ema3DyxyiaA/DAWyeCMLAAA=";
    private static final Log log = LogFactory.getLog(ActorsContentUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<People> data;
    protected JList list;
    protected BeanListHeader<People> listHeader;
    protected JToolBar toolbar;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ActorsContentUI $AbstractContentUI0;
    private JButton $JButton0;
    private JButton $JButton1;
    private JButton $JButton2;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    private void $afterCompleteSetup() {
        getHandler().initUI(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ActorsContentUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ActorsContentUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ActorsContentUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ActorsContentUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ActorsContentUI() {
        $initialize();
    }

    public ActorsContentUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public ActorsContentUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ActorsContentUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().selectChild(this, (People) list.getSelectedValue());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public List<People> getData() {
        return data;
    }

    public JList getList() {
        return list;
    }

    public BeanListHeader<People> getListHeader() {
        return listHeader;
    }

    public JToolBar getToolbar() {
        return toolbar;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setData(List<People> data) {
        List<People> oldValue = this.data;
        this.data = data;
        firePropertyChange(PROPERTY_DATA, oldValue, data);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToToolbar() {
        toolbar.add($JPanel1, BorderLayout.CENTER);
        toolbar.add(listHeader, BorderLayout.EAST);
    }

    protected void createData() {
        $objectMap.put("data", data = null);
    }

    protected void createList() {
        $objectMap.put("list", list = new JList());
        
        list.setName("list");
    }

    protected void createListHeader() {
        $objectMap.put("listHeader", listHeader = new BeanListHeader<People>());
        
        listHeader.setName("listHeader");
        listHeader.setI18nPrefix("jaxxdemo.common.");
        listHeader.setShowReset(true);
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new JToolBar());
        
        toolbar.setName("toolbar");
        toolbar.setFloatable(false);
        toolbar.setLayout(new BorderLayout());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $AbstractContentUI0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$AbstractContentUI0", $AbstractContentUI0);
        createData();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createList();
        createToolbar();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("jaxxdemo.action.show"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(t("jaxxdemo.action.add"));
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setText(t("jaxxdemo.action.remove"));
        createListHeader();
        // inline creation of $AbstractContentUI0
        setName("$AbstractContentUI0");
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON0_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (list != null) {
                    $bindingSources.put("list.getSelectionModel()", list.getSelectionModel());
                    list.getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    list.addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.feature.nav.content.ActorsContentUI.this, BINDING_$JBUTTON0_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (list != null) {
                    $JButton0.setEnabled(list.getSelectedIndex()!=-1);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (list != null) {
                    ListSelectionModel $target = (ListSelectionModel) $bindingSources.remove("list.getSelectionModel()");
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    }
                    list.removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.feature.nav.content.ActorsContentUI.this, BINDING_$JBUTTON0_ENABLED));
                }
            }
        
            public void $pr$u0(ListSelectionEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON2_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (list != null) {
                    $bindingSources.put("list.getSelectionModel()", list.getSelectionModel());
                    list.getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u1"));
                    list.addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.feature.nav.content.ActorsContentUI.this, BINDING_$JBUTTON2_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (list != null) {
                    $JButton2.setEnabled(list.getSelectedIndex()!=-1);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (list != null) {
                    ListSelectionModel $target = (ListSelectionModel) $bindingSources.remove("list.getSelectionModel()");
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u1"));
                    }
                    list.removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.feature.nav.content.ActorsContentUI.this, BINDING_$JBUTTON2_ENABLED));
                }
            }
        
            public void $pr$u1(ListSelectionEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LIST_HEADER_DATA, true ,"data") {
        
            @Override
            public void processDataBinding() {
                listHeader.setData(getData());
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $AbstractContentUI0
        add($JPanel0);
        // inline complete setup of $JPanel0
        $JPanel0.add($JScrollPane0, BorderLayout.CENTER);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(list);
        addChildrenToToolbar();
        // inline complete setup of $JPanel1
        $JPanel1.add($JButton0);
        $JPanel1.add($JButton1);
        $JPanel1.add($JButton2);
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 10 property setters
        $JScrollPane0.setBorder(new TitledBorder(t("jaxxdemo.navigation.actors.title")));
        $JScrollPane0.setColumnHeaderView(toolbar);
        $JScrollPane0.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        $JScrollPane0.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        list.setCellRenderer(getContextValue(DecoratorProviderListCellRenderer.class));
        listHeader.setList(list);
        listHeader.setBeanType(People.class);
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}