/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.reflect;

import java.util.Arrays;
import jaxx.compiler.reflect.ClassDescriptorHelper;
import jaxx.compiler.reflect.FieldDescriptor;
import jaxx.compiler.reflect.MethodDescriptor;
import jaxx.runtime.JAXXObjectDescriptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ClassDescriptor {
    private static final Log log = LogFactory.getLog(ClassDescriptor.class);
    public static final FieldDescriptor[] EMPTY_FIELD_DESCRIPTORS_ARRAY = new FieldDescriptor[0];
    private String name;
    private String packageName;
    private String superclass;
    private String[] interfaces;
    private boolean isInterface;
    private boolean isArray;
    private String componentType;
    private JAXXObjectDescriptor jaxxObjectDescriptor;
    private ClassLoader classLoader;
    private MethodDescriptor[] constructorDescriptors;
    private MethodDescriptor[] methodDescriptors;
    private FieldDescriptor[] fieldDescriptors;
    protected FieldDescriptor[] declaredFieldDescriptors;
    protected final ClassDescriptorHelper.ResolverType resolverType;

    public abstract MethodDescriptor getDeclaredMethodDescriptor(String var1, ClassDescriptor ... var2) throws NoSuchMethodException;

    public FieldDescriptor getDeclaredFieldDescriptor(String name) throws NoSuchFieldException {
        for (FieldDescriptor descriptor : this.declaredFieldDescriptors) {
            if (!name.equals(descriptor.getName())) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using a declared field descriptor [" + name + "] for " + this.getName()));
            }
            return descriptor;
        }
        throw new NoSuchFieldException(name);
    }

    protected ClassDescriptor(ClassDescriptorHelper.ResolverType resolverType, String name, String packageName, String superclass, String[] interfaces, boolean isInterface, boolean isArray, String componentType, JAXXObjectDescriptor jaxxObjectDescriptor, ClassLoader classLoader, MethodDescriptor[] constructorDescriptors, MethodDescriptor[] methodDescriptors, FieldDescriptor[] fieldDescriptors) {
        this(resolverType, name, packageName, superclass, interfaces, isInterface, isArray, componentType, jaxxObjectDescriptor, classLoader, constructorDescriptors, methodDescriptors, fieldDescriptors, null);
    }

    protected ClassDescriptor(ClassDescriptorHelper.ResolverType resolverType, String name, String packageName, String superclass, String[] interfaces, boolean isInterface, boolean isArray, String componentType, JAXXObjectDescriptor jaxxObjectDescriptor, ClassLoader classLoader, MethodDescriptor[] constructorDescriptors, MethodDescriptor[] methodDescriptors, FieldDescriptor[] fieldDescriptors, FieldDescriptor[] declaredFieldDescriptors) {
        this.resolverType = resolverType;
        this.name = name;
        this.packageName = packageName;
        this.superclass = superclass;
        this.interfaces = interfaces;
        this.isInterface = isInterface;
        this.isArray = isArray;
        this.componentType = componentType;
        this.jaxxObjectDescriptor = jaxxObjectDescriptor;
        this.classLoader = classLoader;
        this.constructorDescriptors = constructorDescriptors;
        this.methodDescriptors = methodDescriptors;
        this.fieldDescriptors = fieldDescriptors;
        this.declaredFieldDescriptors = declaredFieldDescriptors;
    }

    public ClassDescriptorHelper.ResolverType getResolverType() {
        return this.resolverType;
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        int dot = this.name.lastIndexOf(".");
        return dot == -1 ? this.name : this.name.substring(dot + 1);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public ClassDescriptor getSuperclass() {
        return this.getClassDescriptor(this.superclass);
    }

    public ClassDescriptor[] getInterfaces() {
        ClassDescriptor[] result = new ClassDescriptor[this.interfaces.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getClassDescriptor(this.interfaces[i]);
        }
        return result;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public ClassDescriptor getComponentType() {
        return this.getClassDescriptor(this.componentType);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public MethodDescriptor[] getConstructorDescriptors() {
        return this.constructorDescriptors;
    }

    public MethodDescriptor[] getMethodDescriptors() {
        return this.methodDescriptors;
    }

    public MethodDescriptor getMethodDescriptor(String name, ClassDescriptor ... parameterTypes) throws NoSuchMethodException {
        for (MethodDescriptor m : this.methodDescriptors) {
            if (!m.getName().equals(name) || m.getParameterTypes().length != parameterTypes.length || !Arrays.equals(m.getParameterTypes(), parameterTypes)) continue;
            return m;
        }
        throw new NoSuchMethodException("Could not find method " + name + "(" + Arrays.asList(parameterTypes) + ") in " + this.getName());
    }

    public FieldDescriptor[] getFieldDescriptors() {
        return this.fieldDescriptors;
    }

    public FieldDescriptor[] getDeclaredFieldDescriptors() {
        return this.declaredFieldDescriptors == null ? EMPTY_FIELD_DESCRIPTORS_ARRAY : this.declaredFieldDescriptors;
    }

    public FieldDescriptor getFieldDescriptor(String name) throws NoSuchFieldException {
        for (FieldDescriptor fieldDescriptor : this.fieldDescriptors) {
            if (!fieldDescriptor.getName().equals(name)) continue;
            return fieldDescriptor;
        }
        throw new NoSuchFieldException("Could not find field " + name + " in " + this.getName());
    }

    public JAXXObjectDescriptor getJAXXObjectDescriptor() {
        return this.jaxxObjectDescriptor;
    }

    public boolean isAssignableFrom(ClassDescriptor descriptor) {
        while (descriptor != null) {
            if (this.equals(descriptor)) {
                return true;
            }
            for (ClassDescriptor anInterface : descriptor.getInterfaces()) {
                if (!this.equals(anInterface)) continue;
                return true;
            }
            descriptor = descriptor.getSuperclass();
        }
        return false;
    }

    public String toString() {
        return "ClassDescriptor[" + this.getName() + "]";
    }

    protected ClassDescriptor getClassDescriptor(String fqn) {
        if (fqn == null) {
            return null;
        }
        try {
            ClassDescriptor result = ClassDescriptorHelper.getClassDescriptor(fqn, this.getClassLoader());
            return result;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

