/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.beans;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import jaxx.compiler.beans.JAXXBeanDescriptor;
import jaxx.compiler.beans.JAXXBeanInfo;
import jaxx.compiler.beans.JAXXEventSetDescriptor;
import jaxx.compiler.beans.JAXXPropertyDescriptor;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorHelper;
import jaxx.compiler.reflect.MethodDescriptor;

public class JAXXIntrospector {
    private ClassDescriptor classDescriptor;
    private Map<String, JAXXPropertyDescriptor> propertyDescriptors = new HashMap<String, JAXXPropertyDescriptor>();
    private Map<String, JAXXEventSetDescriptor> eventSetDescriptors = new HashMap<String, JAXXEventSetDescriptor>();

    private JAXXIntrospector(ClassDescriptor classDescriptor) {
        this.classDescriptor = classDescriptor;
    }

    public static JAXXBeanInfo getJAXXBeanInfo(ClassDescriptor classDescriptor) throws IntrospectionException {
        JAXXIntrospector introspector = new JAXXIntrospector(classDescriptor);
        return introspector.createBeanInfo();
    }

    private JAXXBeanInfo createBeanInfo() {
        BeanDescriptor explicitBeanDescriptor;
        MethodDescriptor[] methods;
        boolean propertyChangeSource;
        BeanInfo explicitBeanInfo = null;
        for (ClassDescriptor explicitInfoClass = this.classDescriptor; explicitInfoClass != null && (explicitBeanInfo = JAXXIntrospector.getExplicitBeanInfo(explicitInfoClass)) == null; explicitInfoClass = explicitInfoClass.getSuperclass()) {
        }
        if (explicitBeanInfo != null) {
            PropertyDescriptor[] explicitProperties;
            for (PropertyDescriptor explicitProperty : explicitProperties = explicitBeanInfo.getPropertyDescriptors()) {
                Class<?> type = explicitProperty.getPropertyType();
                Method readMethod = explicitProperty.getReadMethod();
                Method writeMethod = explicitProperty.getWriteMethod();
                try {
                    ClassDescriptor typeDescriptor = ClassDescriptorHelper.getClassDescriptor(type.getName(), type.getClassLoader());
                    JAXXPropertyDescriptor propertyDescriptor = new JAXXPropertyDescriptor(this.classDescriptor, explicitProperty.getName(), readMethod != null ? this.classDescriptor.getMethodDescriptor(readMethod.getName(), new ClassDescriptor[0]) : null, writeMethod != null ? this.classDescriptor.getMethodDescriptor(writeMethod.getName(), typeDescriptor) : null);
                    propertyDescriptor.setBound(explicitProperty.isBound());
                    Enumeration<String> attributeNames = explicitProperty.attributeNames();
                    while (attributeNames.hasMoreElements()) {
                        String name = attributeNames.nextElement();
                        propertyDescriptor.setValue(name, explicitProperty.getValue(name));
                    }
                    this.propertyDescriptors.put(propertyDescriptor.getName(), propertyDescriptor);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Internal error: Could not find ClassDescriptor corresponding to Java " + type, e);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("Internal error: Could not find expected MethodDescriptor in " + this.classDescriptor, e);
                }
            }
        }
        try {
            this.classDescriptor.getMethodDescriptor("addPropertyChangeListener", ClassDescriptorHelper.getClassDescriptor(PropertyChangeListener.class));
            propertyChangeSource = true;
        }
        catch (NoSuchMethodException e) {
            propertyChangeSource = false;
        }
        for (MethodDescriptor method : methods = this.classDescriptor.getMethodDescriptors()) {
            ClassDescriptor[] parameters;
            String propertyName;
            String name = method.getName();
            if (name.startsWith("get") && name.length() > 3 && Character.isUpperCase(name.charAt(3)) && method.getParameterTypes().length == 0) {
                propertyName = Introspector.decapitalize(name.substring(3));
                if (this.propertyDescriptors.containsKey(propertyName)) continue;
                this.propertyDescriptors.put(propertyName, new JAXXPropertyDescriptor(this.classDescriptor, propertyName, method, null, propertyChangeSource));
                continue;
            }
            if (name.startsWith("is") && name.length() > 2 && Character.isUpperCase(name.charAt(2)) && method.getParameterTypes().length == 0) {
                propertyName = Introspector.decapitalize(name.substring(2));
                if (this.propertyDescriptors.containsKey(propertyName)) continue;
                this.propertyDescriptors.put(propertyName, new JAXXPropertyDescriptor(this.classDescriptor, propertyName, method, null, propertyChangeSource));
                continue;
            }
            if (name.startsWith("set") && name.length() > 3 && Character.isUpperCase(name.charAt(3)) && method.getParameterTypes().length == 1) {
                propertyName = Introspector.decapitalize(name.substring(3));
                if (this.propertyDescriptors.containsKey(propertyName)) continue;
                this.propertyDescriptors.put(propertyName, new JAXXPropertyDescriptor(this.classDescriptor, propertyName, null, method, propertyChangeSource));
                continue;
            }
            if (!name.startsWith("add") || name.length() <= 3 || !Character.isUpperCase(name.charAt(3)) || (parameters = method.getParameterTypes()).length != 1 || !ClassDescriptorHelper.getClassDescriptor(EventListener.class).isAssignableFrom(parameters[0])) continue;
            try {
                String eventSetName = method.getName().substring(3);
                MethodDescriptor remove = this.classDescriptor.getMethodDescriptor("remove" + eventSetName, parameters);
                this.eventSetDescriptors.put(eventSetName, new JAXXEventSetDescriptor(this.classDescriptor, eventSetName, method, remove, parameters[0].getMethodDescriptors()));
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        JAXXBeanDescriptor beanDescriptor = new JAXXBeanDescriptor(this.classDescriptor);
        if (explicitBeanInfo != null && (explicitBeanDescriptor = explicitBeanInfo.getBeanDescriptor()) != null) {
            Enumeration<String> attributeNames = explicitBeanDescriptor.attributeNames();
            while (attributeNames.hasMoreElements()) {
                String name = attributeNames.nextElement();
                beanDescriptor.setValue(name, explicitBeanDescriptor.getValue(name));
            }
        }
        return new JAXXBeanInfo(beanDescriptor, this.propertyDescriptors.values().toArray(new JAXXPropertyDescriptor[this.propertyDescriptors.size()]), this.eventSetDescriptors.values().toArray(new JAXXEventSetDescriptor[this.eventSetDescriptors.size()]));
    }

    private static BeanInfo getExplicitBeanInfo(ClassDescriptor classDescriptor) {
        try {
            Class<?> beanClass = Class.forName(classDescriptor.getName(), true, classDescriptor.getClassLoader());
            Method findExplicitBeanInfo = Introspector.class.getDeclaredMethod("findExplicitBeanInfo", Class.class);
            findExplicitBeanInfo.setAccessible(true);
            return (BeanInfo)findExplicitBeanInfo.invoke(null, beanClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Error: could not find method 'findExplicitBeanInfo' in java.beans.Introspector.  You are most likely running a version of Java against which JAXX has not been tested.");
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

