/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.tasks;

import java.io.Serializable;
import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXCompilerFile;
import jaxx.compiler.JAXXEngine;

public abstract class JAXXEngineTask
implements Serializable {
    private final String name;

    public JAXXEngineTask(String name) {
        this.name = name;
    }

    public abstract boolean perform(JAXXEngine var1) throws Exception;

    public String getName() {
        return this.name;
    }

    protected void addStartProfileTime(JAXXEngine engine, JAXXCompiler compiler) {
        engine.addProfileTime(compiler, this.name + "_start");
    }

    protected void addEndProfileTime(JAXXEngine engine, JAXXCompiler compiler) {
        engine.addProfileTime(compiler, this.name + "_end");
    }

    protected JAXXCompiler getSafeCompiler(JAXXCompilerFile engine) {
        JAXXCompiler compiler = engine.getCompiler();
        if (compiler == null) {
            throw new CompilerException("Internal error: could not find compiler for " + engine.getClassName() + " during task [" + this.getName() + "]");
        }
        return compiler;
    }
}

