/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.reflect;

import java.io.Reader;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXFactory;
import jaxx.compiler.java.parser.JavaParser;
import jaxx.compiler.java.parser.ParseException;
import jaxx.compiler.java.parser.SimpleNode;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorHelper;
import jaxx.compiler.reflect.FieldDescriptor;
import jaxx.compiler.reflect.MethodDescriptor;
import jaxx.compiler.tags.TagManager;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class JavaFileParser {
    private static final Log log = LogFactory.getLog(JavaFileParser.class);
    private JAXXCompiler compiler;
    private String className;
    private String packageName;
    private String superclass;
    private boolean isEnum;
    private boolean isInterface;
    private Set<String> interfaces;
    private List<MethodDescriptor> methods;
    private List<FieldDescriptor> fields;
    private List<FieldDescriptor> declaredFields;
    private String jaxxObjectDescriptorValue;
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    private JavaFileParser(ClassLoader classLoader) {
        this.compiler = JAXXFactory.newDummyCompiler(classLoader);
        this.methods = new ArrayList<MethodDescriptor>();
        this.interfaces = new HashSet<String>();
        this.fields = new ArrayList<FieldDescriptor>();
        this.declaredFields = new ArrayList<FieldDescriptor>();
        this.superclass = Object.class.getName();
    }

    public static ClassDescriptor parseJavaFile(String displayName, Reader src, ClassLoader classLoader) throws ClassNotFoundException {
        JavaFileParser parser = new JavaFileParser(classLoader);
        if (log.isDebugEnabled()) {
            log.debug((Object)("starting parsing : " + displayName));
        }
        try {
            parser.doParse(displayName, src);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            throw new RuntimeException(e);
        }
        JAXXObjectDescriptor jaxxObjectDescriptor = null;
        if (parser.jaxxObjectDescriptorValue != null) {
            jaxxObjectDescriptor = JAXXUtil.decodeCompressedJAXXObjectDescriptor((String)parser.jaxxObjectDescriptorValue);
        }
        List<MethodDescriptor> publicMethods = parser.methods;
        List<FieldDescriptor> publicFields = parser.fields;
        List<FieldDescriptor> declaredFields = parser.declaredFields;
        Iterator<MethodDescriptor> methods = publicMethods.iterator();
        while (methods.hasNext()) {
            MethodDescriptor method = methods.next();
            if (Modifier.isPublic(method.getModifiers())) continue;
            methods.remove();
        }
        Iterator<FieldDescriptor> fields = publicFields.iterator();
        while (fields.hasNext()) {
            FieldDescriptor field = fields.next();
            if (Modifier.isPublic(field.getModifiers())) continue;
            fields.remove();
        }
        if (parser.superclass != null) {
            ClassDescriptor superclassDescriptor = ClassDescriptorHelper.getClassDescriptor(parser.superclass, classLoader);
            publicMethods.addAll(Arrays.asList(superclassDescriptor.getMethodDescriptors()));
            publicFields.addAll(Arrays.asList(superclassDescriptor.getFieldDescriptors()));
        }
        String[] interfaces = parser.interfaces.toArray(new String[parser.interfaces.size()]);
        return new ClassDescriptor(parser.className, parser.packageName, parser.superclass, interfaces, parser.isInterface, false, null, jaxxObjectDescriptor, classLoader, publicMethods.toArray(new MethodDescriptor[publicMethods.size()]), publicFields.toArray(new FieldDescriptor[publicFields.size()]), declaredFields.toArray(new FieldDescriptor[declaredFields.size()])){

            @Override
            public FieldDescriptor getDeclaredFieldDescriptor(String name) throws NoSuchFieldException {
                for (FieldDescriptor descriptor : this.declaredFieldDescriptors) {
                    if (!name.equals(descriptor.getName())) continue;
                    log.info((Object)("Using a declared field descriptor [" + name + "] for " + this.getName()));
                    return descriptor;
                }
                throw new NoSuchFieldException(name);
            }

            @Override
            public MethodDescriptor getDeclaredMethodDescriptor(String name, ClassDescriptor ... parameterTypes) throws NoSuchMethodException {
                throw new NoSuchMethodException(name);
            }
        };
    }

    private void doParse(String displayName, Reader src) {
        try {
            JavaParser p = new JavaParser(src);
            p.CompilationUnit();
            SimpleNode node = p.popNode();
            if (node != null) {
                this.scanCompilationUnit(node);
                return;
            }
            try {
                throw new CompilerException("Internal error: null node parsing Java file from " + src);
            }
            catch (ParseException e) {
                throw new CompilerException("Error parsing Java source code " + displayName + ": " + e.getMessage());
            }
        }
        finally {
            if (this.isInterface) {
                this.superclass = null;
            }
            if (this.isEnum) {
                this.superclass = Enum.class.getName();
            }
        }
    }

    private void scanCompilationUnit(SimpleNode node) {
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            SimpleNode child = node.getChild(i);
            this.scanCompilationUnitChild(child);
        }
    }

    private void scanCompilationUnitChild(SimpleNode child) {
        int nodeType = child.getId();
        switch (nodeType) {
            case 2: {
                this.packageName = child.getChild(1).getText().trim();
                this.compiler.addImport(this.packageName + ".*");
                this.compiler.addImport("java.lang.*");
                break;
            }
            case 3: {
                String text = child.getText().trim();
                if (text.startsWith("import")) {
                    text = text.substring("import".length()).trim();
                }
                if (text.endsWith(";")) {
                    text = text.substring(0, text.length() - 1);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("import " + text));
                }
                this.compiler.addImport(text);
                break;
            }
            case 5: {
                this.scanCompilationUnit(child);
                break;
            }
            case 6: {
                this.isInterface = child.firstToken.image.equals("interface");
                this.scanClass(child);
            }
            case 9: {
                this.isEnum = child.firstToken.image.equals("enum");
                this.scanClass(child);
            }
        }
    }

    private void scanClass(SimpleNode node) {
        this.className = node.firstToken.next.image;
        if (this.packageName != null) {
            this.className = this.packageName + "." + this.className;
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            String rawName;
            SimpleNode child = node.getChild(i);
            int nodeType = child.getId();
            if (nodeType == 8) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[" + this.className + "] Found a implements list " + child + " :: " + child.jjtGetNumChildren()));
                }
                for (int j = 0; j < child.jjtGetNumChildren(); ++j) {
                    rawName = child.getChild(j).getText().trim();
                    this.addInterface(rawName);
                }
                continue;
            }
            if (nodeType == 7) {
                if (this.isInterface) {
                    for (int j = 0; j < child.jjtGetNumChildren(); ++j) {
                        rawName = child.getChild(j).getText().trim();
                        this.addInterface(rawName);
                    }
                    continue;
                }
                assert (child.jjtGetNumChildren() == 1) : "expected ExtendsList to have exactly one child for a non-interface class";
                String rawName2 = child.getChild(0).getText().trim();
                this.superclass = TagManager.resolveClassName(rawName2, this.compiler);
                if (this.superclass == null) {
                    throw new CompilerException("Could not find class: " + rawName2);
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Set superClass = " + this.superclass));
                continue;
            }
            if (nodeType != 15) continue;
            this.scanClassNode(child);
        }
    }

    protected void addInterface(String rawName) {
        String myInterface;
        if (rawName.contains("<")) {
            rawName = rawName.substring(0, rawName.indexOf("<"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.className + "]  try to obtain type of interface " + rawName));
        }
        if ((myInterface = this.resolveFullyQualifiedName(rawName)) == null) {
            throw new CompilerException("Could not find interface: " + myInterface);
        }
        if (!this.interfaces.contains(myInterface)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + this.className + "] add interface " + myInterface));
            }
            this.interfaces.add(myInterface);
        }
    }

    protected String resolveFullyQualifiedName(String rawName) {
        String realRawName = null;
        String realParentRawName = null;
        if (rawName.contains(".")) {
            int index = rawName.lastIndexOf(".");
            realParentRawName = rawName.substring(0, index);
            realRawName = rawName.substring(index + 1);
            log.info((Object)("inner class detected ? " + realParentRawName + "//" + realRawName));
        }
        log.info((Object)("try fqn = " + rawName));
        String result = TagManager.resolveClassName(rawName, this.compiler);
        if (result != null) {
            return result;
        }
        String suffix = "." + rawName;
        if (realParentRawName != null) {
            suffix = "." + realParentRawName;
        }
        for (String aClass : this.compiler.getImportedClasses()) {
            if (!aClass.endsWith(suffix)) continue;
            if (realRawName != null) {
                aClass = aClass + "." + realRawName;
            }
            return aClass;
        }
        Set<String> importedPackages = this.compiler.getImportedPackages();
        for (String aClass : importedPackages) {
            String fqn = aClass + rawName;
            log.info((Object)("try fqn = " + fqn));
            result = TagManager.resolveClassName(fqn, this.compiler);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void scanClassNode(SimpleNode node) {
        int nodeType = node.getId();
        if (nodeType == 22) {
            String returnType = null;
            String name = null;
            ArrayList<String> parameterTypes = new ArrayList<String>();
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                SimpleNode child = node.getChild(i);
                int type = child.getId();
                if (type == 36) {
                    returnType = TagManager.resolveClassName(child.getText().trim(), this.compiler);
                    continue;
                }
                if (type != 23) continue;
                name = child.firstToken.image.trim();
                SimpleNode formalParameters = child.getChild(0);
                assert (formalParameters.getId() == 24);
                for (int j = 0; j < formalParameters.jjtGetNumChildren(); ++j) {
                    SimpleNode parameter = formalParameters.getChild(j);
                    String rawParameterType = parameter.getChild(1).getText().trim().replaceAll("\\.\\.\\.", "[]");
                    String parameterType = TagManager.resolveClassName(rawParameterType, this.compiler);
                    if (parameterType == null && JAXXCompiler.STRICT_CHECKS) {
                        throw new CompilerException("could not find class '" + rawParameterType + "'");
                    }
                    parameterTypes.add(parameterType);
                }
            }
            this.methods.add(new MethodDescriptor(name, 1, returnType, parameterTypes.toArray(new String[parameterTypes.size()]), this.compiler.getClassLoader()));
        } else if (nodeType != 6 && nodeType != 26) {
            if (nodeType == 17) {
                String text;
                String declaration = text = node.getText();
                String value = null;
                int equals = text.indexOf("=");
                if (equals != -1) {
                    value = declaration.substring(equals + 1).trim();
                    declaration = declaration.substring(0, equals);
                }
                declaration = declaration.trim();
                int modifiers = this.isInterface ? 25 : this.getModifiers(node);
                log.info((Object)("field [" + declaration + "] modifiers == " + Modifier.toString(modifiers)));
                String[] declarationTokens = declaration.split("\\s");
                String name = declarationTokens[declarationTokens.length - 1];
                if (name.endsWith(";")) {
                    name = name.substring(0, name.length() - 1).trim();
                }
                String cName = declarationTokens[declarationTokens.length - 2];
                String type = TagManager.resolveClassName(cName, this.compiler);
                FieldDescriptor descriptor = new FieldDescriptor(name, modifiers, type, this.compiler.getClassLoader());
                if ("$jaxxObjectDescriptor".equals(name) && value != null) {
                    int firstIndex = value.indexOf("\"");
                    int lastIndex = value.lastIndexOf("\"");
                    this.jaxxObjectDescriptorValue = value.substring(firstIndex + 1, lastIndex);
                    log.info((Object)("detected a $jaxxObjectDescriptor = " + this.jaxxObjectDescriptorValue));
                }
                if (Modifier.isPublic(modifiers)) {
                    this.fields.add(descriptor);
                } else {
                    this.declaredFields.add(descriptor);
                }
            } else {
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    SimpleNode child = node.getChild(i);
                    this.scanClassNode(child);
                }
            }
        }
    }

    protected int getModifiers(SimpleNode node) {
        SimpleNode parentNode = node.getParent();
        for (int i = 0; i < parentNode.jjtGetNumChildren(); ++i) {
            SimpleNode child = parentNode.getChild(i);
            if (child.getId() != 4) continue;
            String modifiersStr = child.getText().trim();
            int modifiers = this.scanModifiers(modifiersStr);
            return modifiers;
        }
        return 0;
    }

    protected int scanModifiers(String modifiersStr) {
        int modifiers = 0;
        if (modifiersStr.contains("public")) {
            modifiers |= 1;
        }
        if (modifiersStr.contains("protected")) {
            modifiers |= 4;
        }
        if (modifiersStr.contains("private")) {
            modifiers |= 2;
        }
        if (modifiersStr.contains("static")) {
            modifiers |= 8;
        }
        if (modifiersStr.contains("final")) {
            modifiers |= 0x10;
        }
        if (modifiersStr.contains("volatile")) {
            modifiers |= 0x40;
        }
        if (modifiersStr.contains("transient")) {
            modifiers |= 0x80;
        }
        if (modifiersStr.contains("synchronized")) {
            modifiers |= 0x20;
        }
        if (modifiersStr.contains("abstract")) {
            modifiers |= 0x400;
        }
        return modifiers;
    }
}

