/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.binding;

import java.util.List;
import jaxx.compiler.binding.AbstractJAXXBindingWriter;
import jaxx.compiler.binding.DataBinding;
import jaxx.compiler.binding.DataListener;
import jaxx.compiler.binding.JavaParserUtil;
import jaxx.compiler.java.JavaArgument;
import jaxx.compiler.java.JavaFileGenerator;
import jaxx.compiler.java.JavaMethod;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;

public class SimpleJAXXObjectBindingWriter
extends AbstractJAXXBindingWriter<SimpleJAXXObjectBinding> {
    protected boolean used;

    public SimpleJAXXObjectBindingWriter() {
        super(SimpleJAXXObjectBinding.class);
    }

    @Override
    public boolean accept(DataBinding binding) {
        DataListener[] trackers = binding.getTrackers();
        if (trackers.length > 0) {
            for (DataListener tracker : trackers) {
                if (tracker.getObjectCode() == null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected String getConstructorParams(DataBinding binding, DataListener[] trackers) {
        StringBuilder addBuffer = new StringBuilder();
        addBuffer.append("this, ").append(binding.getConstantId()).append(", true");
        for (DataListener tracker : trackers) {
            String symbol = tracker.getSymbol();
            String propertyName = symbol.substring(symbol.indexOf(".") + 1);
            if (JavaParserUtil.getMethodInvocationParameters(propertyName) != null) {
                propertyName = JavaParserUtil.getPropertyNameFromMethod(propertyName);
            }
            addBuffer.append(" ,\"").append(propertyName).append("\"");
        }
        return addBuffer.toString();
    }

    @Override
    public void write(DataBinding binding, JavaFileGenerator generator, StringBuilder buffer) {
        DataListener[] trackers = binding.getTrackers();
        List<JavaMethod> bMethods = binding.getMethods();
        bMethods.add(0, JavaFileGenerator.newMethod(1, "void", "processDataBinding", binding.getProcessDataBinding(), true, new JavaArgument[0]));
        this.writeInvocationMethod(binding, trackers, generator, buffer, bMethods);
    }
}

