/*
 * #%L
 * JAXX :: Compiler
 * 
 * $Id: JAXXEngineTask.java 1865 2010-05-02 16:55:27Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.0.2/jaxx-compiler/src/main/java/jaxx/compiler/tasks/JAXXEngineTask.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.compiler.tasks;

import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXCompilerFile;
import jaxx.compiler.JAXXEngine;

import java.io.Serializable;

/**
 * Base class to implement a task to be launched by a {@link JAXXEngine}.
 * <p/>
 * The {@link #perform(JAXXEngine)} method contains the logic of the task.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.0.2
 */
public abstract class JAXXEngineTask implements Serializable {

    private final String name;

    public JAXXEngineTask(String name) {
        this.name = name;
    }

    public abstract boolean perform(JAXXEngine engine) throws Exception;


    public String getName() {
        return name;
    }

    protected void addStartProfileTime(JAXXEngine engine,
                                       JAXXCompiler compiler) {
        engine.addProfileTime(compiler, name + "_start");
    }

    protected void addEndProfileTime(JAXXEngine engine,
                                     JAXXCompiler compiler) {
        engine.addProfileTime(compiler, name + "_end");
    }

    protected JAXXCompiler getSafeCompiler(JAXXCompilerFile engine) {
        JAXXCompiler compiler = engine.getCompiler();
        if (compiler == null) {
            throw new CompilerException(
                    "Internal error: could not find compiler for " +
                    engine.getClassName() + " during task [" + getName() + "]"
            );
        }

        return compiler;
    }
//
//    protected JAXXCompiler getSafeCompiler(JAXXEngine engine,
//                                           String className) {
//        JAXXCompiler compiler = engine.getCompiler(
//                className,
//                "Internal error: could not find compiler for " + className +
//                " during task [" + getName() + "]");
//        return compiler;
//    }
}
