/*
 * Decompiled with CFR 0.152.
 */
package jaxx.tags;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.lang.reflect.Field;
import jaxx.CompilerException;
import jaxx.UnsupportedAttributeException;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.I18nHelper;
import jaxx.compiler.JAXXCompiler;
import jaxx.reflect.ClassDescriptor;
import jaxx.reflect.ClassDescriptorLoader;
import jaxx.runtime.Util;
import jaxx.tags.DefaultObjectHandler;
import jaxx.tags.TagManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class DefaultComponentHandler
extends DefaultObjectHandler {
    protected static final Log log = LogFactory.getLog(DefaultComponentHandler.class);
    private String containerDelegate;

    public DefaultComponentHandler(ClassDescriptor beanClass) {
        super(beanClass);
        ClassDescriptorLoader.checkSupportClass(this.getClass(), beanClass, Component.class);
    }

    @Override
    protected void init() throws IntrospectionException {
        if (this.jaxxBeanInfo == null) {
            super.init();
            this.containerDelegate = (String)this.getJAXXBeanInfo().getJAXXBeanDescriptor().getValue("containerDelegate");
            if (this.containerDelegate == null && ClassDescriptorLoader.getClassDescriptor(Container.class).isAssignableFrom(this.getBeanClass().getSuperclass())) {
                this.containerDelegate = ((DefaultComponentHandler)TagManager.getTagHandler(this.getBeanClass().getSuperclass())).getContainerDelegate();
            }
        }
    }

    @Override
    protected void configureProxyEventInfo() {
        super.configureProxyEventInfo();
        this.addProxyEventInfo("hasFocus", FocusListener.class);
        this.addProxyEventInfo("isVisible", ComponentListener.class);
        this.addProxyEventInfo("getBounds", ComponentListener.class);
        this.addProxyEventInfo("getLocation", ComponentListener.class);
        this.addProxyEventInfo("getLocationOnScreen", ComponentListener.class);
        this.addProxyEventInfo("getSize", ComponentListener.class);
        this.addProxyEventInfo("getX", ComponentListener.class);
        this.addProxyEventInfo("getY", ComponentListener.class);
        this.addProxyEventInfo("getWidth", ComponentListener.class);
        this.addProxyEventInfo("getHeight", ComponentListener.class);
        if (ClassDescriptorLoader.getClassDescriptor(Container.class).isAssignableFrom(this.getBeanClass())) {
            this.addProxyEventInfo("getComponentCount", ContainerListener.class);
        }
    }

    @Override
    protected void setDefaults(CompiledObject object, Element tag, JAXXCompiler compiler) throws CompilerException {
        super.setDefaults(object, tag, compiler);
        this.setAttribute(object, "name", object.getId(), false, compiler);
        this.openComponent(object, tag, compiler);
    }

    @Override
    public void compileFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        super.compileFirstPass(tag, compiler);
    }

    @Override
    public void compileSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        super.compileSecondPass(tag, compiler);
        this.closeComponent(compiler.getOpenComponent(), tag, compiler);
    }

    protected void openComponent(CompiledObject object, Element tag, JAXXCompiler compiler) throws CompilerException {
        String constraints = tag.getAttribute("constraints");
        if (constraints != null && constraints.length() > 0) {
            compiler.openComponent(object, constraints);
        } else {
            compiler.openComponent(object);
        }
    }

    protected void closeComponent(CompiledObject object, Element tag, JAXXCompiler compiler) throws CompilerException {
        compiler.closeComponent(object);
    }

    @Override
    public boolean isPropertyInherited(String property) throws UnsupportedAttributeException {
        return property.equals("font") || property.startsWith("font-") || property.equals("foreground") || property.equals("enabled");
    }

    @Override
    public ClassDescriptor getPropertyType(CompiledObject object, String propertyName, JAXXCompiler compiler) throws CompilerException {
        if (propertyName.equals("x") || propertyName.equals("y") || propertyName.equals("width") || propertyName.equals("height") || "font-size".equals(propertyName)) {
            return ClassDescriptorLoader.getClassDescriptor(Integer.class);
        }
        if (propertyName.equals("font-face") || propertyName.equals("font-style") || propertyName.equals("font-weight")) {
            return ClassDescriptorLoader.getClassDescriptor(String.class);
        }
        return super.getPropertyType(object, propertyName, compiler);
    }

    @Override
    public String getGetPropertyCode(String id, String name, JAXXCompiler compiler) throws CompilerException {
        if (name.equals("font-face")) {
            return id + ".getFont().getFontName()";
        }
        if (name.equals("font-size")) {
            return id + ".getFont().getSize()";
        }
        if (name.equals("font-weight")) {
            return "(" + id + ".getFont().getStyle() & Font.BOLD) != 0 ? \"bold\" : \"normal\"";
        }
        if (name.equals("font-style")) {
            return "(" + id + ".getFont().getStyle() & Font.ITALIC) != 0 ? \"italic\" : \"normal\"";
        }
        return super.getGetPropertyCode(id, name, compiler);
    }

    @Override
    public String getSetPropertyCode(String id, String name, String valueCode, JAXXCompiler compiler) throws CompilerException {
        String containerDelegate;
        if (name.equals("x")) {
            return id + ".setLocation(" + valueCode + ", " + id + ".getY());";
        }
        if (name.equals("y")) {
            return id + ".setLocation(" + id + ".getX(), " + valueCode + ");";
        }
        if (name.equals("width")) {
            return "jaxx.runtime.Util.setComponentWidth(" + id + "," + valueCode + ");\n";
        }
        if (name.equals("height")) {
            return "jaxx.runtime.Util.setComponentHeight(" + id + "," + valueCode + ");\n";
        }
        if (name.equals("font-face")) {
            return "if (" + id + ".getFont() != null) " + id + ".setFont(new Font(" + valueCode + ", " + id + ".getFont().getStyle(), " + id + ".getFont().getSize()));";
        }
        if (name.equals("font-size")) {
            return "if (" + id + ".getFont() != null) " + id + ".setFont(" + id + ".getFont().deriveFont((float) " + valueCode + "));";
        }
        if (name.equals("font-weight")) {
            if (valueCode.equals("\"bold\"")) {
                return "if (" + id + ".getFont() != null) " + id + ".setFont(" + id + ".getFont().deriveFont(" + id + ".getFont().getStyle() | Font.BOLD));";
            }
            if (valueCode.equals("\"normal\"")) {
                return "if (" + id + ".getFont() != null) " + id + ".setFont(" + id + ".getFont().deriveFont(" + id + ".getFont().getStyle() & ~Font.BOLD));";
            }
            if (!valueCode.startsWith("\"")) {
                return "if (" + id + ".getFont() != null) { if ((" + valueCode + ").equals(\"bold\")) " + id + ".setFont(" + id + ".getFont().deriveFont(" + id + ".getFont().getStyle() | Font.BOLD)); else " + id + ".setFont(" + id + ".getFont().deriveFont(" + id + ".getFont().getStyle() & ~Font.BOLD)); }";
            }
            compiler.reportError("font-weight must be either \"normal\" or \"bold\", found " + valueCode);
            return "";
        }
        if (name.equals("font-style")) {
            if (valueCode.equals("\"italic\"")) {
                return "if (" + id + ".getFont() != null) " + id + ".setFont(" + id + ".getFont().deriveFont(" + id + ".getFont().getStyle() | Font.ITALIC));";
            }
            if (valueCode.equals("\"normal\"")) {
                return "if (" + id + ".getFont() != null) " + id + ".setFont(" + id + ".getFont().deriveFont(" + id + ".getFont().getStyle() & ~Font.ITALIC));";
            }
            if (!valueCode.startsWith("\"")) {
                return "if (" + id + ".getFont() != null) { if ((" + valueCode + ").equals(\"italic\")) " + id + ".setFont(" + id + ".getFont().deriveFont(" + id + ".getFont().getStyle() | Font.ITALIC)); else " + id + ".setFont(" + id + ".getFont().deriveFont(" + id + ".getFont().getStyle() & ~Font.ITALIC)); }";
            }
            compiler.reportError("font-style must be either \"normal\" or \"italic\", found " + valueCode);
            return "";
        }
        if (ClassDescriptorLoader.getClassDescriptor(Container.class).isAssignableFrom(this.getBeanClass()) && name.equals("layout") && (containerDelegate = (String)this.getJAXXBeanInfo().getJAXXBeanDescriptor().getValue("containerDelegate")) != null) {
            return id + '.' + containerDelegate + "().setLayout(" + valueCode + ");";
        }
        if (I18nHelper.isI18nableAttribute(name, compiler)) {
            valueCode = I18nHelper.addI18nInvocation(id, name, valueCode, compiler);
        }
        return super.getSetPropertyCode(id, name, valueCode, compiler);
    }

    @Override
    public void setAttribute(CompiledObject object, String propertyName, String stringValue, boolean inline, JAXXCompiler compiler) {
        if (propertyName.startsWith("_")) {
            if (stringValue.startsWith("{")) {
                stringValue = stringValue.substring(1, stringValue.length() - 1);
            }
            object.addClientProperty(propertyName.substring(1), stringValue);
            return;
        }
        if ("icon".equals(propertyName)) {
            if (!stringValue.startsWith("{") && !stringValue.endsWith("}")) {
                stringValue = compiler.getOptions().isUseUIManagerForIcon() ? "{" + Util.class.getName() + ".getUIManagerIcon(\"" + stringValue + "\")}" : "{" + Util.class.getName() + ".createImageIcon(\"" + stringValue + "\")}";
            }
        } else if ("actionIcon".equals(propertyName)) {
            if (stringValue.startsWith("{") && stringValue.endsWith("}")) {
                compiler.reportError("the actionIcon does not support script, remove braces..., fix the file " + compiler.getOutputClassName());
                return;
            }
            propertyName = "icon";
            stringValue = compiler.getOptions().isUseUIManagerForIcon() ? "{" + Util.class.getName() + ".getUIManagerActionIcon(\"" + stringValue + "\")}" : "{" + Util.class.getName() + ".createActionIcon(\"" + stringValue + "\")}";
        }
        super.setAttribute(object, propertyName, stringValue, inline, compiler);
    }

    @Override
    protected void scanAttributesForDependencies(Element tag, JAXXCompiler compiler) {
        super.scanAttributesForDependencies(tag, compiler);
        NamedNodeMap children = tag.getAttributes();
        int max = children.getLength();
        for (int i = 0; i < max; ++i) {
            String value;
            Attr attr = (Attr)children.item(i);
            String name = attr.getName();
            if (!name.startsWith("_") || !(value = attr.getValue()).startsWith("{")) continue;
            compiler.reportWarning(tag, "an clientProperty attribute " + name.substring(1) + " does not required curly value but was : " + value, 0);
        }
    }

    @Override
    protected int constantValue(String key, String value) {
        if (key.equals("mnemonic") || key.equals("displayedMnemonic")) {
            if (value.length() == 1) {
                return value.charAt(0);
            }
            try {
                Field vk = KeyEvent.class.getField(value);
                return (Integer)vk.get(null);
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException("mnemonics must be either a single character or the name of a field in KeyEvent (found: '" + value + "')");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return super.constantValue(key, value);
    }

    public boolean isContainer() {
        boolean container = ClassDescriptorLoader.getClassDescriptor(Container.class).isAssignableFrom(this.getBeanClass());
        if (container) {
            try {
                this.init();
                if (Boolean.FALSE.equals(this.getJAXXBeanInfo().getJAXXBeanDescriptor().getValue("isContainer"))) {
                    container = false;
                }
            }
            catch (IntrospectionException e) {
                throw new RuntimeException(e);
            }
        }
        return container;
    }

    public String getContainerDelegate() {
        try {
            this.init();
            return this.containerDelegate;
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }
}

