/*
 * Decompiled with CFR 0.152.
 */
package jaxx.css;

import java.util.Stack;
import jaxx.css.Node;

class JJTCSSParserState {
    private Stack<Node> nodes = new Stack();
    private Stack<Integer> marks = new Stack();
    private int sp = 0;
    private int mk = 0;
    private boolean node_created;

    JJTCSSParserState() {
    }

    boolean nodeCreated() {
        return this.node_created;
    }

    void reset() {
        this.nodes.removeAllElements();
        this.marks.removeAllElements();
        this.sp = 0;
        this.mk = 0;
    }

    Node rootNode() {
        return (Node)this.nodes.elementAt(0);
    }

    void pushNode(Node n) {
        this.nodes.push(n);
        ++this.sp;
    }

    Node popNode() {
        if (--this.sp < this.mk) {
            this.mk = this.marks.pop();
        }
        return this.nodes.pop();
    }

    Node peekNode() {
        return this.nodes.peek();
    }

    int nodeArity() {
        return this.sp - this.mk;
    }

    void clearNodeScope(Node n) {
        while (this.sp > this.mk) {
            this.popNode();
        }
        this.mk = this.marks.pop();
    }

    void openNodeScope(Node n) {
        this.marks.push(this.mk);
        this.mk = this.sp;
        n.jjtOpen();
    }

    void closeNodeScope(Node n, int num) {
        this.mk = this.marks.pop();
        while (num-- > 0) {
            Node c = this.popNode();
            c.jjtSetParent(n);
            n.jjtAddChild(c, num);
        }
        n.jjtClose();
        this.pushNode(n);
        this.node_created = true;
    }

    void closeNodeScope(Node n, boolean condition) {
        if (condition) {
            int a = this.nodeArity();
            this.mk = this.marks.pop();
            while (a-- > 0) {
                Node c = this.popNode();
                c.jjtSetParent(n);
                n.jjtAddChild(c, a);
            }
            n.jjtClose();
            this.pushNode(n);
            this.node_created = true;
        } else {
            this.mk = this.marks.pop();
            this.node_created = false;
        }
    }
}

