/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.tags.validator;

import jaxx.compiler.JAXXCompiler;
import jaxx.reflect.ClassDescriptorLoader;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.tags.TagManager;

public class ValidatorInitializer implements jaxx.spi.Initializer {

    @Override
    public void initialize() {

        TagManager.registerTag(JAXXCompiler.JAXX_NAMESPACE, BeanValidatorHandler.TAG, new BeanValidatorHandler(ClassDescriptorLoader.getClassDescriptor(SwingValidator.class)));
        TagManager.registerBean(ClassDescriptorLoader.getClassDescriptor(SwingValidator.class), BeanValidatorHandler.class);
        TagManager.registerTag(JAXXCompiler.JAXX_NAMESPACE, FieldValidatorHandler.TAG, new FieldValidatorHandler());
        TagManager.registerTag(JAXXCompiler.JAXX_NAMESPACE, ExcludeFieldValidatorHandler.TAG, new FieldValidatorHandler());
    }
}