/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.tags.swing;

import jaxx.CompilerException;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.JAXXCompiler;
import jaxx.reflect.ClassDescriptor;
import jaxx.reflect.ClassDescriptorLoader;
import jaxx.tags.DefaultComponentHandler;

import java.awt.event.ItemListener;
import jaxx.runtime.swing.editor.LocaleEditor;

public class LocaleEditorHandler extends DefaultComponentHandler {

    public LocaleEditorHandler(ClassDescriptor beanClass) {
        super(beanClass);
        ClassDescriptorLoader.checkSupportClass(getClass(), beanClass, LocaleEditor.class);
    }

    @Override
    protected void configureProxyEventInfo() {
        super.configureProxyEventInfo();
        addProxyEventInfo("getSelectedIndex", ItemListener.class);
        addProxyEventInfo("getSelectedItem", ItemListener.class);
    }

    @Override
    protected CompiledObject createCompiledObject(String id, JAXXCompiler compiler) throws CompilerException {
        return new CompiledItemContainer(id, getBeanClass(), compiler);
    }
//    @Override
//    public void compileChildrenSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
//        super.compileChildrenSecondPass(tag, compiler);
//        CompiledItemContainer list = (CompiledItemContainer) compiler.getOpenComponent();
//        List<Item> items = list.getItems();
//        if (items != null && !items.isEmpty()) {
//            String listName = list.getId() + "$items";
//            list.appendAdditionCode("java.util.List<jaxx.runtime.swing.Item> " + listName + " = new java.util.ArrayList<jaxx.runtime.swing.Item>();");
//            for (Item item : items) {
//                String id = item.getId();
//                CompiledObject compiledItem = new CompiledObject(id, ClassDescriptorLoader.getClassDescriptor(Item.class), compiler);
//                compiledItem.setConstructorParams(TypeManager.getJavaCode(id) + ", " + TypeManager.getJavaCode(item.getLabel()) + ", " + TypeManager.getJavaCode(item.getValue()) + ", " + item.isSelected());
//                compiler.registerCompiledObject(compiledItem);
//                list.appendAdditionCode(listName + ".add(" + id + ");");
//            }
//            list.appendAdditionCode(list.getId() + ".setItems(" + listName + ");");
//        }
//    }
}



