package jaxx.reflect;

/**
 * Mirrors the class <code>java.lang.ref.Member</code>.  JAXX uses <code>ClassDescriptor</code> instead of <code>Class</code>
 * almost everywhere so that it can handle circular dependencies (there can't be a <code>Class</code> object for an uncompiled
 * JAXX or Java source file, and a compiler must be allow references to symbols in uncompiled source files in order to handle
 * circular dependencies).
 */
public abstract class MemberDescriptor {
    private String name;
    private int modifiers;
    private ClassLoader classLoader;


    MemberDescriptor(String name, int modifiers, ClassLoader classLoader) {
        this.name = name;
        this.modifiers = modifiers;
        this.classLoader = classLoader;
    }


    public String getName() {
        return name;
    }


    public int getModifiers() {
        return modifiers;
    }


    protected ClassLoader getClassLoader() {
        return classLoader;
    }

    @Override
    public String toString() {
        return getClass().getName() + "[" + getName() + "]";
    }
}