/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package jaxx.compiler;

import java.lang.reflect.Modifier;
import java.util.Map.Entry;
import jaxx.CompilerException;
import jaxx.types.TypeManager;

/**
 * The default compiledObjectDecorator.
 * 
 * @author tony
 * @since 1.2
 */
public class DefaultCompiledObjectDecorator extends CompiledObjectDecorator {

    @Override
    public void finalizeCompiler(JAXXCompiler compiler, CompiledObject root, CompiledObject object, JavaFile javaFile, String packageName, String className, String fullClassName) {

        if (!object.isOverride() && !(object instanceof ScriptInitializer)) {
            String id = object.getId();
            int access = id.startsWith("$") ? Modifier.PRIVATE : Modifier.PROTECTED;
            if (object == root) {
                javaFile.addField(new JavaField(access, fullClassName, id, "this"));
            } else {
                //TC -20081017 can have generic on compiled Object
                javaFile.addField(JavaField.newField(access, JAXXCompiler.getCanonicalName(object), id), object.isJavaBean());
            }
        }

        if (!compiler.inlineCreation(object) && object != root) {
            javaFile.addMethod(JavaMethod.newMethod(Modifier.PROTECTED, "void", object.getCreationMethodName(), getCreationCode(compiler, object)));
        }
    }

    @Override
    public String getCreationCode(JAXXCompiler compiler, CompiledObject object) throws CompilerException {
        if (object instanceof ScriptInitializer) {
            return object.getInitializationCode(compiler);
        }
        StringBuffer result = new StringBuffer();
        if (object.isOverride() && object.getOverrideType()==object.getObjectClass()) {
            //TC-20090309 on utilise le super code quand l'objet est de meme type
            result.append("super.").append(object.getCreationMethodName()).append("();");
        } else {
            result.append(object.getId());
            result.append(" = ");
            if (object.isJavaBean() && object.getJavaBeanInitCode() != null) {
                result.append(object.getJavaBeanInitCode()).append(";");
            } else {
                String constructorParams = object.getConstructorParams();
                if (constructorParams != null) {
                    //TC - 20081017 compiledObject can have generics
                    result.append(" new ").append(JAXXCompiler.getCanonicalName(object)).append("(").append(constructorParams).append(");");
                    //result.append("(").append(getCanonicalName(object.getObjectClass())).append(") new ").append(getCanonicalName(object.getObjectClass())).append("(").append(constructorParams).append(");");
                } else {
                    //TC - 20081017 compiledObject can have generics
                    result.append("new ").append(JAXXCompiler.getCanonicalName(object)).append("();");
                }
            }
            result.append(JAXXCompiler.getLineSeparator());
            result.append("$objectMap.put(").append(TypeManager.getJavaCode(object.getId())).append(", ").append(object.getId()).append(");");
        }
        result.append(JAXXCompiler.getLineSeparator());
        String initCode = object.getInitializationCode(compiler);
        if (initCode != null && initCode.length() > 0) {
            result.append(initCode);
        }

        return result.toString();
    }

    @Override
    public String createCompleteSetupMethod(JAXXCompiler compiler, CompiledObject object, JavaFile javaFile, StringBuffer initDataBindings) {
        StringBuffer code = new StringBuffer();
        //TC-20090327 generate client properties
        if (object.hasClientProperties()) {
            // generate putClientProperty invocations
            for (Entry<String,String> entry : object.getClientProperties().entrySet()) {
                object.appendAdditionCode(object.getJavaCode() + ".putClientProperty(\"" + entry.getKey() + "\", " + entry.getValue() + ");");
            }

        }
        //TC - 20081017 only generate the method if not empty ?
        if (object.getId().startsWith("$")) {
            code.append(object.getAdditionCode()).append(JAXXCompiler.getLineSeparator());
        } else {            
            String additionCode = object.getAdditionCode();
            if (additionCode.length() > 0) {
                code.append(object.getAdditionMethodName()).append("();").append(JAXXCompiler.getLineSeparator());
                additionCode = "if (!allComponentsCreated) {" + JAXXCompiler.getLineSeparator() + "    return;" + JAXXCompiler.getLineSeparator() + "}" + JAXXCompiler.getLineSeparator() + additionCode;
                javaFile.addMethod(JavaMethod.newMethod(Modifier.PROTECTED, "void", object.getAdditionMethodName(), additionCode));
            }
        }
        //code.append(getLineSeparator());
        return code.toString();
    }

    @Override
    public boolean createInitializer(JAXXCompiler compiler, CompiledObject root, CompiledObject object, StringBuffer code, boolean lastWasMethodCall) {
        if (object == root) {
            String rootCode = root.getInitializationCode(compiler);
            if (rootCode != null && rootCode.length() > 0) {
                code.append(rootCode);
                code.append(JAXXCompiler.getLineSeparator());
            }
        } else {
            if (!object.isOverride()) {
                if (compiler.inlineCreation(object)) {
                    if (lastWasMethodCall) {
                        lastWasMethodCall = false;
                        code.append(JAXXCompiler.getLineSeparator());
                    }
                    code.append(getCreationCode(compiler, object));
                    code.append(JAXXCompiler.getLineSeparator());
                } else {
                    code.append(object.getCreationMethodName()).append("();");
                    code.append(JAXXCompiler.getLineSeparator());
                    lastWasMethodCall = true;
                }
            }
        }
        return lastWasMethodCall;
    }
}
