package jaxx.compiler;

import jaxx.compiler.CompiledObject.ChildRef;
import jaxx.runtime.SwingUtil;

/**
 * A decorator to surround a compiled object (should be a component at least)
 * with a JXLayer.
 * 
 * @author tony
 * @since 1.2
 */
public class BoxedCompiledObjectDecorator extends DefaultCompiledObjectDecorator {

    @Override
    public void finalizeCompiler(JAXXCompiler compiler, CompiledObject root, CompiledObject object, JavaFile javaFile, String packageName, String className, String fullClassName) {
        CompiledObject parent = object.getParent();
        for (ChildRef child : parent.getChilds()) {
            if (child.getChild() == object) {
                String javaCode = child.getChildJavaCode();
                child.setChildJavaCode(SwingUtil.class.getName()+".boxComponentWithJxLayer(" + javaCode + ")");
                break;
            }
        }
        super.finalizeCompiler(compiler, root, object, javaFile, packageName, className, fullClassName);
    }
}
