/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx;

/** Thrown by the runtime engine when a script error occurs. */
public class ScriptException extends RuntimeException {
    private static final long serialVersionUID = 5687529939397610336L;

    /** Creates a new <code>ScriptException</code>. */
    public ScriptException() {
    }


    /**
     * Creates a new <code>ScriptException</code> with the specified detail message.
     *
     * @param msg the exception's detail message
     */
    public ScriptException(String msg) {
        super(msg);
    }


    /**
     * Creates a new <code>ScriptException</code> with the specified cause.
     *
     * @param initCause the exception's initCause
     */
    public ScriptException(Throwable initCause) {
        super(initCause);
    }


    /**
     * Creates a new <code>ScriptException</code> with the specified detail message and cause.
     *
     * @param msg       the exception's detail message
     * @param initCause the exception's initCause
     */
    public ScriptException(String msg, Throwable initCause) {
        super(msg, initCause);
    }
}