/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx;

/** Thrown by the compiler when an error occurs. */
public class CompilerException extends RuntimeException {
    private static final long serialVersionUID = -9099889519671482440L;

    /** Creates a new <code>ParseException</code>. */
    public CompilerException() {
    }


    /**
     * Creates a new <code>ParseException</code> with the specified detail message.
     *
     * @param msg the exception's detail message
     */
    public CompilerException(String msg) {
        super(msg);
    }


    /**
     * Creates a new <code>ParseException</code> with the specified cause.
     *
     * @param initCause the exception's initCause
     */
    public CompilerException(Throwable initCause) {
        super(initCause);
    }


    /**
     * Creates a new <code>ParseException</code> with the specified detail message and cause.
     *
     * @param msg       the exception's detail message
     * @param initCause the exception's initCause
     */
    public CompilerException(String msg, Throwable initCause) {
        super(msg, initCause);
    }


    public void printStackTrace() {
        super.printStackTrace();
        System.err.println("CompilerException printed from:");
        Thread.dumpStack();
    }
}