/*
 * Decompiled with CFR 0.152.
 */
package jaxx.tags.swing;

import java.awt.GridBagConstraints;
import java.io.IOException;
import jaxx.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.reflect.ClassDescriptorLoader;
import jaxx.runtime.swing.Table;
import jaxx.tags.TagHandler;
import jaxx.tags.swing.CellHandler;
import jaxx.tags.swing.TableHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class RowHandler
implements TagHandler {
    @Override
    public void compileFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        this.compileChildrenFirstPass(tag, compiler);
    }

    @Override
    public void compileSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        if (!ClassDescriptorLoader.getClassDescriptor(Table.class).isAssignableFrom(compiler.getOpenComponent().getObjectClass())) {
            compiler.reportError("row tag may only appear within Table tag");
            return;
        }
        TableHandler.CompiledTable table = (TableHandler.CompiledTable)compiler.getOpenComponent();
        table.newRow();
        GridBagConstraints c = table.getRowConstraints();
        CellHandler.setAttributes(c, tag);
        this.compileChildrenSecondPass(tag, compiler);
    }

    public void compileChildrenFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        NodeList children = tag.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String text;
            Node node = children.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 1) {
                Element child = (Element)node;
                if (!child.getLocalName().equals("cell")) {
                    compiler.reportError("tag '" + tag.getLocalName() + "' may only contain cell tags as children");
                }
                this.compileChildTagFirstPass(child, compiler);
                continue;
            }
            if (nodeType != 3 && nodeType != 4 || (text = ((Text)node).getData().trim()).length() <= 0) continue;
            compiler.reportError("tag '" + tag.getLocalName() + "' may not contain text ('" + ((Text)node).getData().trim() + "')");
        }
    }

    public void compileChildrenSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        NodeList children = tag.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String text;
            Node node = children.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 1) {
                Element child = (Element)node;
                if (!child.getLocalName().equals("cell")) {
                    compiler.reportError("tag '" + tag.getLocalName() + "' may only contain cell tags as children");
                }
                this.compileChildTagSecondPass(child, compiler);
                continue;
            }
            if (nodeType != 3 && nodeType != 4 || (text = ((Text)node).getData().trim()).length() <= 0) continue;
            compiler.reportError("tag '" + tag.getLocalName() + "' may not contain text ('" + ((Text)node).getData().trim() + "')");
        }
    }

    protected void compileChildTagFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        compiler.compileFirstPass(tag);
    }

    protected void compileChildTagSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        compiler.compileSecondPass(tag);
    }
}

