/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler;

import java.util.Map;
import jaxx.CompilerException;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompiledObjectDecorator;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JavaArgument;
import jaxx.compiler.JavaField;
import jaxx.compiler.JavaFile;
import jaxx.compiler.JavaMethod;
import jaxx.compiler.ScriptInitializer;
import jaxx.types.TypeManager;

public class DefaultCompiledObjectDecorator
extends CompiledObjectDecorator {
    @Override
    public void finalizeCompiler(JAXXCompiler compiler, CompiledObject root, CompiledObject object, JavaFile javaFile, String packageName, String className, String fullClassName) {
        if (!object.isOverride() && !(object instanceof ScriptInitializer)) {
            int access;
            String id = object.getId();
            int n = access = id.startsWith("$") ? 2 : 4;
            if (object == root) {
                javaFile.addField(new JavaField(access, fullClassName, id, "this"));
            } else {
                javaFile.addField(JavaField.newField(access, JAXXCompiler.getCanonicalName(object), id), object.isJavaBean());
            }
        }
        if (!compiler.inlineCreation(object) && object != root) {
            javaFile.addMethod(JavaMethod.newMethod(4, "void", object.getCreationMethodName(), this.getCreationCode(compiler, object), new JavaArgument[0]));
        }
    }

    @Override
    public String getCreationCode(JAXXCompiler compiler, CompiledObject object) throws CompilerException {
        if (object instanceof ScriptInitializer) {
            return object.getInitializationCode(compiler);
        }
        StringBuffer result = new StringBuffer();
        if (object.isOverride() && object.getOverrideType() == object.getObjectClass()) {
            result.append("super.").append(object.getCreationMethodName()).append("();");
        } else {
            result.append(object.getId());
            result.append(" = ");
            if (object.isJavaBean() && object.getJavaBeanInitCode() != null) {
                result.append(object.getJavaBeanInitCode()).append(";");
            } else {
                String constructorParams = object.getConstructorParams();
                if (constructorParams != null) {
                    result.append(" new ").append(JAXXCompiler.getCanonicalName(object)).append("(").append(constructorParams).append(");");
                } else {
                    result.append("new ").append(JAXXCompiler.getCanonicalName(object)).append("();");
                }
            }
            result.append(JAXXCompiler.getLineSeparator());
            result.append("$objectMap.put(").append(TypeManager.getJavaCode(object.getId())).append(", ").append(object.getId()).append(");");
        }
        result.append(JAXXCompiler.getLineSeparator());
        String initCode = object.getInitializationCode(compiler);
        if (initCode != null && initCode.length() > 0) {
            result.append(initCode);
        }
        return result.toString();
    }

    @Override
    public String createCompleteSetupMethod(JAXXCompiler compiler, CompiledObject object, JavaFile javaFile, StringBuffer initDataBindings) {
        StringBuffer code = new StringBuffer();
        if (object.hasClientProperties()) {
            for (Map.Entry<String, String> entry : object.getClientProperties().entrySet()) {
                object.appendAdditionCode(object.getJavaCode() + ".putClientProperty(\"" + entry.getKey() + "\", " + entry.getValue() + ");");
            }
        }
        if (object.getId().startsWith("$")) {
            code.append(object.getAdditionCode()).append(JAXXCompiler.getLineSeparator());
        } else {
            String additionCode = object.getAdditionCode();
            if (additionCode.length() > 0) {
                code.append(object.getAdditionMethodName()).append("();").append(JAXXCompiler.getLineSeparator());
                additionCode = "if (!allComponentsCreated) {" + JAXXCompiler.getLineSeparator() + "    return;" + JAXXCompiler.getLineSeparator() + "}" + JAXXCompiler.getLineSeparator() + additionCode;
                javaFile.addMethod(JavaMethod.newMethod(4, "void", object.getAdditionMethodName(), additionCode, new JavaArgument[0]));
            }
        }
        return code.toString();
    }

    @Override
    public boolean createInitializer(JAXXCompiler compiler, CompiledObject root, CompiledObject object, StringBuffer code, boolean lastWasMethodCall) {
        if (object == root) {
            String rootCode = root.getInitializationCode(compiler);
            if (rootCode != null && rootCode.length() > 0) {
                code.append(rootCode);
                code.append(JAXXCompiler.getLineSeparator());
            }
        } else if (!object.isOverride()) {
            if (compiler.inlineCreation(object)) {
                if (lastWasMethodCall) {
                    lastWasMethodCall = false;
                    code.append(JAXXCompiler.getLineSeparator());
                }
                code.append(this.getCreationCode(compiler, object));
                code.append(JAXXCompiler.getLineSeparator());
            } else {
                code.append(object.getCreationMethodName()).append("();");
                code.append(JAXXCompiler.getLineSeparator());
                lastWasMethodCall = true;
            }
        }
        return lastWasMethodCall;
    }
}

