/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler;

import java.awt.Container;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jaxx.CompilerException;
import jaxx.compiler.CompiledObjectDecorator;
import jaxx.compiler.EventHandler;
import jaxx.compiler.JAXXCompiler;
import jaxx.reflect.ClassDescriptor;
import jaxx.reflect.ClassDescriptorLoader;
import jaxx.reflect.MethodDescriptor;
import jaxx.tags.DefaultComponentHandler;
import jaxx.tags.DefaultObjectHandler;
import jaxx.tags.TagManager;
import jaxx.types.TypeManager;
import org.apache.commons.lang.StringUtils;

public class CompiledObject {
    private String id;
    private String javaCode;
    private ClassDescriptor objectClass;
    private String styleClass;
    private CompiledObject parent;
    private boolean override;
    private String constructorParams;
    private StringBuffer initializationCode = new StringBuffer();
    private StringBuffer additionCode = new StringBuffer();
    private List<EventHandler> eventHandlers = new ArrayList<EventHandler>();
    private Map<String, String> properties = new HashMap<String, String>();
    private String[] genericTypes;
    private boolean javaBean;
    private String javaBeanInitCode;
    private ClassDescriptor overrideType;
    private CompiledObjectDecorator decorator;
    private Map<String, String> clientProperties;
    private List<ChildRef> childs;

    public CompiledObject(String id, ClassDescriptor objectClass, JAXXCompiler compiler) {
        this(id, objectClass, compiler, false);
    }

    public CompiledObject(String id, ClassDescriptor objectClass, JAXXCompiler compiler, boolean force) {
        this(id, id, objectClass, compiler, force);
    }

    public CompiledObject(String id, String javaCode, ClassDescriptor objectClass, JAXXCompiler compiler, boolean force) throws CompilerException {
        if (!force && !CompiledObject.isValidID(id)) {
            compiler.reportError("the id '" + id + "' is not a valid Java identifier");
        }
        this.id = id;
        this.javaCode = javaCode;
        if (objectClass == null) {
            throw new NullPointerException();
        }
        this.objectClass = objectClass;
        this.childs = new ArrayList<ChildRef>();
    }

    public static boolean isValidID(String id) {
        boolean valid = true;
        if (id.length() == 0) {
            valid = false;
        }
        if (valid) {
            if (!Character.isJavaIdentifierStart(id.charAt(0))) {
                valid = false;
            }
            if (valid) {
                for (int i = 1; i < id.length(); ++i) {
                    if (Character.isJavaIdentifierPart(id.charAt(i))) continue;
                    valid = false;
                    break;
                }
            }
        }
        return valid;
    }

    public boolean isOverride() {
        return this.override;
    }

    public void setOverride(boolean override) {
        this.override = override;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public CompiledObject getParent() {
        return this.parent;
    }

    public void setParent(CompiledObject parent) {
        if (!ClassDescriptorLoader.getClassDescriptor(Container.class).isAssignableFrom(parent.getObjectClass())) {
            throw new IllegalArgumentException("parent must descend from java.awt.Container");
        }
        this.parent = parent;
    }

    public String getCreationMethodName() {
        return "create" + StringUtils.capitalize((String)this.getId());
    }

    public String getAdditionMethodName() {
        return "addChildrenTo" + StringUtils.capitalize((String)this.getId());
    }

    public ClassDescriptor getObjectClass() {
        return this.objectClass;
    }

    public String getId() {
        return this.id;
    }

    public String getJavaCode() {
        String result = this.javaCode;
        if (this.isOverride()) {
            result = "((" + JAXXCompiler.getCanonicalName(this.getObjectClass()) + ") " + this.javaCode + ")";
        }
        return result;
    }

    public String getJavaCodeForProperty(String property) {
        if (!this.override) {
            return this.javaCode;
        }
        String result = "((" + JAXXCompiler.getCanonicalName(this.getObjectClass()) + ") " + this.javaCode + ")";
        String methodName = StringUtils.capitalize((String)property);
        try {
            MethodDescriptor methodDescriptor = this.overrideType.getMethodDescriptor("get" + methodName, new ClassDescriptor[0]);
            if (methodDescriptor != null && this.overrideType.getMethodDescriptor("set" + methodName, methodDescriptor.getReturnType()) != null) {
                result = this.javaCode;
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return result;
    }

    public String getConstructorParams() {
        return this.constructorParams;
    }

    public void setConstructorParams(String constructorParams) {
        this.constructorParams = constructorParams;
    }

    public String getInitializationCode(JAXXCompiler compiler) {
        StringBuffer result = new StringBuffer(this.initializationCode.toString());
        Iterator<EventHandler> i$ = this.eventHandlers.iterator();
        while (i$.hasNext()) {
            EventHandler eventHandler;
            EventHandler handler = eventHandler = i$.next();
            result.append(this.getInitializationCode(handler, compiler));
        }
        return result.toString();
    }

    protected String getInitializationCode(EventHandler handler, JAXXCompiler compiler) {
        MethodDescriptor addMethod = handler.getAddMethod();
        ClassDescriptor listenerClass = addMethod.getParameterTypes()[0];
        return this.getJavaCode() + '.' + addMethod.getName() + "((" + JAXXCompiler.getCanonicalName(listenerClass) + ") jaxx.runtime.Util.getEventListener(" + JAXXCompiler.getCanonicalName(listenerClass) + ".class, " + TypeManager.getJavaCode(handler.getListenerMethod().getName()) + ", " + compiler.getRootObject().getJavaCode() + ", " + TypeManager.getJavaCode(compiler.getEventHandlerMethodName(handler)) + "));" + JAXXCompiler.getLineSeparator();
    }

    public String getAdditionCode() {
        return this.additionCode.toString();
    }

    public void appendInitializationCode(String code) {
        this.initializationCode.append(code);
        this.initializationCode.append(JAXXCompiler.getLineSeparator());
    }

    public void appendAdditionCode(String code) {
        this.additionCode.append(code);
        this.additionCode.append(JAXXCompiler.getLineSeparator());
    }

    public void addProperty(String property, String value) {
        this.properties.put(property, value);
    }

    public boolean hasClientProperties() {
        return this.clientProperties != null && !this.clientProperties.isEmpty();
    }

    public void addClientProperty(String property, String value) {
        this.getClientProperties().put(property, value);
    }

    public String getClientProperty(String key) {
        if (!this.hasClientProperties()) {
            return null;
        }
        return this.clientProperties.get(key);
    }

    public Map<String, String> getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new HashMap<String, String>();
        }
        return this.clientProperties;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void addEventHandler(String eventId, Method addMethod, Method listenerMethod, String code, JAXXCompiler compiler) {
        try {
            ClassDescriptor descriptor = ClassDescriptorLoader.getClassDescriptor(this.getObjectClass().getName());
            String listenerClassName = addMethod.getParameterTypes()[0].getName();
            ClassDescriptor listenerDescriptor = ClassDescriptorLoader.getClassDescriptor(listenerClassName);
            MethodDescriptor addMethodDescriptor = descriptor.getMethodDescriptor(addMethod.getName(), listenerDescriptor);
            MethodDescriptor listenerMethodDescriptor = listenerDescriptor.getMethodDescriptor(listenerMethod.getName(), ClassDescriptorLoader.getClassDescriptor(listenerMethod.getParameterTypes()[0].getName()));
            this.addEventHandler(eventId, addMethodDescriptor, listenerMethodDescriptor, code, compiler);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addEventHandler(String eventId, MethodDescriptor addMethod, MethodDescriptor listenerMethod, String code, JAXXCompiler compiler) {
        EventHandler handler = new EventHandler(this.getId() + "." + eventId, this.getJavaCode(), addMethod, addMethod.getParameterTypes()[0], listenerMethod, code);
        compiler.registerEventHandler(handler);
        this.eventHandlers.add(handler);
        if (this.getJavaCode().indexOf(".") != -1) {
            compiler.appendInitializerCode(this.getInitializationCode(handler, compiler));
        }
    }

    public void addChild(CompiledObject child, JAXXCompiler compiler) throws CompilerException {
        this.addChild(child, null, compiler);
    }

    public void addChild(CompiledObject child, String constraints, JAXXCompiler compiler) throws CompilerException {
        try {
            if (constraints != null) {
                constraints = compiler.checkJavaCode(constraints);
            }
        }
        catch (CompilerException e) {
            compiler.reportError("While parsing 'constraints' attribute: " + e.getMessage());
        }
        if (!child.isOverride()) {
            String containerDelegate;
            DefaultObjectHandler tagHandler = TagManager.getTagHandler(this.getObjectClass());
            if (tagHandler instanceof DefaultComponentHandler && !((DefaultComponentHandler)tagHandler).isContainer()) {
                compiler.reportError("component " + this + " may not have children");
            }
            String delegateCode = (containerDelegate = ((DefaultComponentHandler)tagHandler).getContainerDelegate()) != null ? "." + containerDelegate + "()" : "";
            child.setParent(this);
            this.childs.add(new ChildRef(child, constraints, child.getJavaCode(), delegateCode));
        }
    }

    public String toString() {
        return this.getObjectClass().getName() + "[id='" + this.id + "']";
    }

    public void registerDataBinding(String src, String property, String assignment, JAXXCompiler compiler) throws CompilerException {
        compiler.registerDataBinding(src, this.getId() + "." + property, assignment);
    }

    public String getGenericTypes() {
        if (this.getGenericTypesLength() == 0) {
            return "";
        }
        String result = "";
        int j = this.getGenericTypesLength();
        for (int i = 0; i < j; ++i) {
            result = result + ", " + this.genericTypes[i];
        }
        return "< " + result.substring(2) + " >";
    }

    public void setGenericTypes(String[] genericTypes) {
        if (genericTypes == null) {
            this.genericTypes = null;
            return;
        }
        this.genericTypes = new String[genericTypes.length];
        int j = genericTypes.length;
        for (int i = 0; i < j; ++i) {
            this.genericTypes[i] = genericTypes[i].trim();
        }
    }

    public boolean isJavaBean() {
        return this.javaBean;
    }

    public void setJavaBean(boolean javaBean) {
        this.javaBean = javaBean;
    }

    public ClassDescriptor getOverrideType() {
        return this.overrideType;
    }

    public void setOverrideType(ClassDescriptor overrideType) {
        this.overrideType = overrideType;
    }

    public String getJavaBeanInitCode() {
        return this.javaBeanInitCode;
    }

    public void setJavaBeanInitCode(String javaBeanInitCode) {
        this.javaBeanInitCode = javaBeanInitCode;
    }

    public List<ChildRef> getChilds() {
        return this.childs;
    }

    public CompiledObjectDecorator getDecorator() {
        return this.decorator;
    }

    public void setDecorator(CompiledObjectDecorator decorator) {
        this.decorator = decorator;
    }

    public void finalizeCompiler() {
        StringBuffer buffer = new StringBuffer();
        List<ChildRef> refList = this.getChilds();
        if (refList == null || refList.isEmpty()) {
            return;
        }
        for (ChildRef childRef : refList) {
            childRef.addToAdditionCode(buffer);
        }
        this.additionCode = buffer.append(this.additionCode);
    }

    public int getGenericTypesLength() {
        return this.genericTypes == null ? 0 : this.genericTypes.length;
    }

    public class ChildRef {
        CompiledObject child;
        String constraints;
        String childJavaCode;
        String delegateCode;

        public ChildRef(CompiledObject child, String constraints, String childJavaCode, String delegateCode) {
            this.child = child;
            this.constraints = constraints;
            this.childJavaCode = childJavaCode;
            this.delegateCode = delegateCode;
        }

        public CompiledObject getChild() {
            return this.child;
        }

        public void setChild(CompiledObject child) {
            this.child = child;
        }

        public String getConstraints() {
            return this.constraints;
        }

        public void setConstraints(String constraints) {
            this.constraints = constraints;
        }

        public String getChildJavaCode() {
            return this.childJavaCode;
        }

        public void setChildJavaCode(String childJavaCode) {
            this.childJavaCode = childJavaCode;
        }

        public String getDelegateCode() {
            return this.delegateCode;
        }

        public void setDelegateCode(String delegateCode) {
            this.delegateCode = delegateCode;
        }

        public void addToAdditionCode(StringBuffer buffer) {
            if (this.constraints != null) {
                buffer.append(CompiledObject.this.javaCode).append(this.delegateCode).append(".add(").append(this.childJavaCode).append(", ").append(this.constraints).append(");");
            } else {
                buffer.append(CompiledObject.this.javaCode).append(this.delegateCode).append(".add(").append(this.childJavaCode).append(");");
            }
            buffer.append(JAXXCompiler.getLineSeparator());
        }
    }
}

