/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.types;

import jaxx.types.*;
import java.awt.Color;
import java.lang.reflect.Field;

public class ColorConverter implements TypeConverter {
    public String getJavaCode(Object object) {
        Color color = (Color) object;
        return "new Color(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ")";
    }


    public Object convertFromString(String string, Class type) {
        if (type != Color.class) {
            throw new IllegalArgumentException("unsupported type: " + type);
        }
        if (string.length() == 7 && string.charAt(0) == '#') {
            return new Color(Integer.parseInt(string.substring(1), 16));
        }
        try {
            Field color = Color.class.getField(string);
            return color.get(null);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("colors must be of the form #xxxxxx ('#' followed by six hexadecimal digits), or the name of a constant field in java.awt.Color (found: '" + string + "')");
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}