/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.tags.swing;

import jaxx.CompilerException;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.JAXXCompiler;
import jaxx.reflect.ClassDescriptor;
import jaxx.reflect.ClassDescriptorLoader;
import jaxx.tags.DefaultComponentHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

import javax.swing.JTextArea;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import jaxx.runtime.SwingUtil;

public class JTextComponentHandler extends DefaultComponentHandler {
    private static final int DEFAULT_COLUMNS = 15;

    public JTextComponentHandler(ClassDescriptor beanClass) {
        super(beanClass);
        ClassDescriptorLoader.checkSupportClass(getClass(), beanClass, JTextComponent.class);
    }

    @Override
    protected void setDefaults(CompiledObject object, Element tag, JAXXCompiler compiler) throws CompilerException {
        super.setDefaults(object, tag, compiler);
        try {
            object.getObjectClass().getMethodDescriptor("setColumns", ClassDescriptorLoader.getClassDescriptor(int.class));
            setAttribute(object, "columns", String.valueOf(DEFAULT_COLUMNS), false, compiler);
        }
        catch (NoSuchMethodException e) {
            // ignore ?
        }

        if (ClassDescriptorLoader.getClassDescriptor(JTextArea.class).isAssignableFrom(object.getObjectClass())) {
            setAttribute(object, "lineWrap", "true", false, compiler);
            setAttribute(object, "wrapStyleWord", "true", false, compiler);
        }
    }

    @Override
    public String getSetPropertyCode(String id, String name, String valueCode, JAXXCompiler compiler) throws CompilerException {
        if (name.equals("text")) {
            return SwingUtil.class.getName()+".setText(" + id + ", " + valueCode + ");\n";
            //return "jaxx.runtime.swing.Utils.setText(" + id + ", " + valueCode + ");\n";
        }
        return super.getSetPropertyCode(id, name, valueCode, compiler);
    }

    @Override
    protected int getAttributeOrdering(Attr attr) {
        // delay text in case other attributes affect how it's processed, as is the case
        // with JEditorPane's contentType
        if (attr.getName().equals("text")) {
            return 1;
        }
        return super.getAttributeOrdering(attr);
    }

    @Override
    protected void configureProxyEventInfo() {
        super.configureProxyEventInfo();
        addProxyEventInfo("getText", DocumentListener.class, "document");
    }
}