/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.tags.swing;

import jaxx.reflect.ClassDescriptor;
import jaxx.reflect.ClassDescriptorLoader;

import javax.swing.JPasswordField;
import javax.swing.event.DocumentListener;

public class JPasswordFieldHandler extends JTextComponentHandler {

    public JPasswordFieldHandler(ClassDescriptor beanClass) {
        super(beanClass);
        ClassDescriptorLoader.checkSupportClass(getClass(), beanClass, JPasswordField.class);
    }

    @Override
    protected void configureProxyEventInfo() {
        super.configureProxyEventInfo();
        addProxyEventInfo("getPassword", DocumentListener.class, "document");
    }
}
