package jaxx.introspection;

import jaxx.reflect.ClassDescriptor;
import jaxx.reflect.MethodDescriptor;

/**
 * Mirrors the class <code>java.beans.EventSetDescriptor</code>.  JAXX uses its own introspector rather than the built-in
 * <code>java.beans.Introspector</code> so that it can introspect {@link jaxx.reflect.ClassDescriptor},
 * not just <code>java.lang.Class</code>.
 */
public class JAXXEventSetDescriptor extends JAXXFeatureDescriptor {
    private MethodDescriptor addListenerMethod;
    private MethodDescriptor removeListenerMethod;
    private MethodDescriptor[] listenerMethods;


    public JAXXEventSetDescriptor(ClassDescriptor classDescriptor, String name, MethodDescriptor addListenerMethod,
                                  MethodDescriptor removeListenerMethod, MethodDescriptor[] listenerMethods) {
        super(classDescriptor, name);
        this.addListenerMethod = addListenerMethod;
        this.removeListenerMethod = removeListenerMethod;
        this.listenerMethods = listenerMethods;
    }


    public MethodDescriptor getAddListenerMethod() {
        return addListenerMethod;
    }


    public MethodDescriptor getRemoveListenerMethod() {
        return removeListenerMethod;
    }


    public MethodDescriptor[] getListenerMethods() {
        return listenerMethods;
    }
}