package jaxx.introspection;

/**
 * Mirrors the class <code>java.beans.BeanInfo</code>.  JAXX uses its own introspector rather than the built-in
 * <code>java.beans.Introspector</code> so that it can introspect {@link jaxx.reflect.ClassDescriptor},
 * not just <code>java.lang.Class</code>.
 */
public class JAXXBeanInfo {
    private JAXXBeanDescriptor beanDescriptor;
    private JAXXPropertyDescriptor[] propertyDescriptors;
    private JAXXEventSetDescriptor[] eventSetDescriptors;


    public JAXXBeanInfo(JAXXBeanDescriptor beanDescriptor,
                        JAXXPropertyDescriptor[] propertyDescriptors,
                        JAXXEventSetDescriptor[] eventSetDescriptors) {
        this.beanDescriptor = beanDescriptor;
        this.propertyDescriptors = propertyDescriptors;
        this.eventSetDescriptors = eventSetDescriptors;
    }


    public JAXXBeanDescriptor getJAXXBeanDescriptor() {
        return beanDescriptor;
    }


    public JAXXPropertyDescriptor[] getJAXXPropertyDescriptors() {
        return propertyDescriptors;
    }


    public JAXXEventSetDescriptor[] getJAXXEventSetDescriptors() {
        return eventSetDescriptors;
    }
}