package jaxx.compiler;

import jaxx.reflect.FieldDescriptor;
import jaxx.reflect.MethodDescriptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** Symbol table constructed during the first pass of compilation. */
public class SymbolTable {

    private String superclass;

    // maps ID strings to class names -- we can't map directly to CompiledObjects, because we
    // can't create those until after the first pass
    private Map<String, String> ids = new HashMap<String, String>();

    private List<FieldDescriptor> scriptFields = new ArrayList<FieldDescriptor>();

    private List<MethodDescriptor> scriptMethods = new ArrayList<MethodDescriptor>();


    /** @return the fully-qualified name of the superclass of the class described by this symbol table. */
    public String getSuperclassName() {
        return superclass;
    }


    public void setSuperclassName(String superclass) {
        this.superclass = superclass;
    }


    /**
     * @return a map of IDs to class names.  Each entry in the map corresponds to a class tag with an
     *         <code>id</code> attribute.  The <code>id</code> is the key, and the fully-qualified class name
     *         of the tag is the value.
     */
    public Map<String, String> getClassTagIds() {
        return ids;
    }


    /** @return a list of <code>FieldDescriptors</code> for fields defined in &lt;script&gt; tags. */
    public List<FieldDescriptor> getScriptFields() {
        return scriptFields;
    }


    /** @return a list of <code>MethodDescriptors</code> for methods defined in &lt;script&gt; tags. */
    public List<MethodDescriptor> getScriptMethods() {
        return scriptMethods;
    }
}