package jaxx.compiler;

import jaxx.reflect.ClassDescriptorLoader;

import java.lang.reflect.Modifier;

/** @author chemit */
public class SwingGenerator implements Generator {
    @Override
    public void finalizeCompiler(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) {

    }

    @Override
    public void prepareJavaFile(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) throws ClassNotFoundException {

        //TODO : move this to jaxx-compiler-swing generator
        if (ClassDescriptorLoader.getClassDescriptor("jaxx.runtime.swing.Application").isAssignableFrom(root.getObjectClass()) && !compiler.isMainDeclared()) {
            // TODO: check for existing main method first
            javaFile.addMethod(JavaMethod.newMethod(Modifier.PUBLIC | Modifier.STATIC, "void", "main",
                    "SwingUtilities.invokeLater(new Runnable() { public void run() { new " + className + "().setVisible(true); } });",
                    new JavaArgument("String[]", "arg"))
            );
        }
    }
}
