/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx;

import jaxx.compiler.JAXXCompiler;
import jaxx.reflect.ClassDescriptorLoader;
import jaxx.tags.DefaultComponentHandler;
import jaxx.tags.DefaultObjectHandler;
import jaxx.tags.ScriptHandler;
import jaxx.tags.StyleHandler;
import jaxx.tags.TagManager;
import jaxx.types.PrimitiveConverter;
import jaxx.types.TypeManager;

import java.awt.Component;
import jaxx.compiler.CompiledObjectDecorator;
import jaxx.compiler.DefaultCompiledObjectDecorator;

/** Initializes support for java. */
public class DefaultInitializer implements jaxx.spi.Initializer {

    @Override
    public void initialize() {
        TagManager.registerBean(ClassDescriptorLoader.getClassDescriptor(Object.class), DefaultObjectHandler.class);
        TagManager.registerBean(ClassDescriptorLoader.getClassDescriptor(Component.class), DefaultComponentHandler.class);
        TagManager.registerTag(JAXXCompiler.JAXX_NAMESPACE, "script", new ScriptHandler());
        TagManager.registerTag(JAXXCompiler.JAXX_NAMESPACE, "style", new StyleHandler());

        PrimitiveConverter primitiveConverter = new PrimitiveConverter();
        TypeManager.registerTypeConverter(boolean.class, primitiveConverter);
        TypeManager.registerTypeConverter(Boolean.class, primitiveConverter);
        TypeManager.registerTypeConverter(byte.class, primitiveConverter);
        TypeManager.registerTypeConverter(Byte.class, primitiveConverter);
        TypeManager.registerTypeConverter(short.class, primitiveConverter);
        TypeManager.registerTypeConverter(Short.class, primitiveConverter);
        TypeManager.registerTypeConverter(int.class, primitiveConverter);
        TypeManager.registerTypeConverter(Integer.class, primitiveConverter);
        TypeManager.registerTypeConverter(long.class, primitiveConverter);
        TypeManager.registerTypeConverter(Long.class, primitiveConverter);
        TypeManager.registerTypeConverter(float.class, primitiveConverter);
        TypeManager.registerTypeConverter(Float.class, primitiveConverter);
        TypeManager.registerTypeConverter(double.class, primitiveConverter);
        TypeManager.registerTypeConverter(Double.class, primitiveConverter);
        TypeManager.registerTypeConverter(char.class, primitiveConverter);
        TypeManager.registerTypeConverter(Character.class, primitiveConverter);
        TypeManager.registerTypeConverter(String.class, primitiveConverter);

        CompiledObjectDecorator.registerDecorator("default", DefaultCompiledObjectDecorator.class);
    }
}