/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.bundle;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Properties;
import org.nuiton.i18n.bundle.I18nBundleEntry;
import org.nuiton.i18n.bundle.I18nBundleUtil;
import org.nuiton.i18n.plugin.bundle.AbstractMakeI18nBundleMojo;
import org.nuiton.io.SortedProperties;
import org.nuiton.plugin.PluginHelper;

public class TapestryBundleMojo
extends AbstractMakeI18nBundleMojo {
    protected void doAction() throws Exception {
        long t00 = System.nanoTime();
        if (!this.silent) {
            this.getLog().info((CharSequence)("config - bundle name : " + this.bundleOutputName));
            this.getLog().info((CharSequence)("config - basedir     : " + this.bundleOutputDir));
            this.getLog().info((CharSequence)("config - locales     : " + Arrays.toString(this.locales)));
        }
        LinkedHashMap<Locale, String> bundleDico = new LinkedHashMap<Locale, String>(this.locales.length);
        for (Locale locale : this.locales) {
            long t0 = System.nanoTime();
            File bundleOut = this.getTapestryI18nFile(this.bundleOutputDir, this.bundleOutputName, locale, false);
            if (!this.silent) {
                this.getLog().info((CharSequence)("generate bundle for locale " + locale + " in file " + bundleOut.getName()));
            }
            SortedProperties propertiesOut = new SortedProperties(this.encoding, false);
            StringBuilder buffer = new StringBuilder();
            URL[] urls = this.getCollectI18nResources(locale);
            if (urls.length == 0) {
                this.getLog().warn((CharSequence)("no bundle for locale " + locale));
                continue;
            }
            for (URL url : urls) {
                long t000 = System.nanoTime();
                I18nBundleEntry bundleEntry = new I18nBundleEntry(url, locale, null);
                bundleEntry.load((Properties)propertiesOut);
                String strPath = bundleEntry.getPath().toString();
                int index = strPath.indexOf("i18n/");
                buffer.append(',').append(strPath.substring(index));
                if (!this.verbose) continue;
                this.getLog().info((CharSequence)("loaded " + bundleEntry.getPath() + " in " + PluginHelper.convertTime((long)t000, (long)System.nanoTime())));
            }
            if (buffer.length() > 0) {
                bundleDico.put(locale, buffer.substring(1));
                if (!this.silent) {
                    this.getLog().info((CharSequence)("bundles for locale : " + (String)bundleDico.get(locale)));
                }
            }
            propertiesOut.store(bundleOut);
            if (!this.silent && this.verbose) {
                this.getLog().info((CharSequence)("bundle created in " + PluginHelper.convertTime((long)t0, (long)System.nanoTime()) + " (detected sentences : " + propertiesOut.size() + ")"));
            }
            if (!this.checkBundle) continue;
            this.checkBundle(locale, (Properties)propertiesOut, this.showEmpty, this.unsafeMapping);
        }
        this.failsIfWarning();
        if (!this.silent && this.verbose) {
            this.getLog().info((CharSequence)("done in " + PluginHelper.convertTime((long)t00, (long)System.nanoTime())));
        }
    }

    public File getTapestryI18nFile(File root, String artifactId, Locale locale, boolean create) throws IOException {
        File file = new File(root.getAbsolutePath() + File.separatorChar + artifactId + "_" + locale.getLanguage() + ".properties");
        if (create && !file.exists()) {
            this.createNewFile(file);
        }
        return file;
    }

    @Override
    protected URL[] getCollectI18nResources(Locale locale) throws IOException {
        File file = this.getCollectOutputFile(locale, false);
        if (!file.exists()) {
            return I18nBundleUtil.EMPTY_URL_ARRAY;
        }
        URL[] urls = PluginHelper.getLinesAsURL((File)file);
        return urls;
    }
}

