/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser;

import java.io.File;
import java.util.ArrayList;
import org.nuiton.i18n.plugin.parser.AbstractI18nParserMojo;
import org.nuiton.i18n.plugin.parser.SourceEntry;

public class I18nSourceEntry
extends SourceEntry {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    public boolean init(AbstractI18nParserMojo mojo) {
        boolean todo;
        String mojoName = mojo.getClass().getSimpleName();
        if (mojoName.endsWith("Mojo")) {
            mojoName = mojoName.substring(0, mojoName.length() - 4);
        }
        if (!this.useForGoal(mojoName)) {
            this.skipMessage = "exclude for this goal.";
            return true;
        }
        String[] filesForEntry = this.getFilesForEntry(mojo);
        if (filesForEntry.length == 0) {
            this.skipMessage = "no file found.";
            return true;
        }
        this.setUpdater(mojo.newFileUpdater(this));
        if (mojo.isStrictMode() || this.updater == null) {
            this.skipFiles = EMPTY_STRING_ARRAY;
            this.files = filesForEntry;
            return false;
        }
        ArrayList<String> listFiles = new ArrayList<String>();
        ArrayList<String> listSkipFiles = new ArrayList<String>();
        for (String foundFile : filesForEntry) {
            File file = new File(this.getBasedir(), foundFile);
            if (this.isFileUptodate(file)) {
                listSkipFiles.add(foundFile);
                continue;
            }
            listFiles.add(foundFile);
        }
        boolean bl = todo = !listFiles.isEmpty();
        if (!todo) {
            this.skipMessage = "all files are up to date.";
            this.skipFiles = listSkipFiles.toArray(new String[listSkipFiles.size()]);
            this.files = EMPTY_STRING_ARRAY;
            return true;
        }
        this.skipFiles = listSkipFiles.toArray(new String[listSkipFiles.size()]);
        this.files = listFiles.toArray(new String[listFiles.size()]);
        return false;
    }

    protected String[] getFilesForEntry(AbstractI18nParserMojo mojo) {
        return this.getIncludedFiles(mojo.getDefaultBasedir(), mojo.getDefaultIncludes(), mojo.getDefaultExcludes());
    }
}

