/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin;

import com.google.common.base.Joiner;
import com.google.common.io.Files;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.nuiton.eugene.plugin.modelextension.AttributeBean;
import org.nuiton.eugene.plugin.modelextension.ClassBean;
import org.nuiton.eugene.plugin.modelextension.ModelBean;
import org.nuiton.eugene.plugin.modelextension.ModelBeanBuilder;
import org.nuiton.eugene.plugin.modelextension.PackageBean;
import org.nuiton.plugin.AbstractPlugin;

@Mojo(name="transform-compact-to-flat-properties")
public class TransformCompactToFlatPropertiesMojo
extends AbstractPlugin {
    @Parameter(property="eugene.modelName", required=true)
    protected String modelName;
    @Parameter(property="eugene.directory", defaultValue="${project.basedir}/src/main/xmi", required=true)
    protected File directory;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="eugene.dryRun")
    protected boolean dryRun;
    @Parameter(property="eugene.verbose", defaultValue="${maven.verbose}")
    protected boolean verbose;
    @Parameter(property="eugene.encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    protected File[] inputFiles;
    protected File outputFile;
    protected String eol;

    protected void init() throws Exception {
        this.eol = SystemUtils.LINE_SEPARATOR;
        this.inputFiles = this.directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".objectmodel-ext");
            }
        });
        this.getLog().info((CharSequence)("Found " + this.inputFiles.length + " model extension file(s)."));
        this.outputFile = new File(this.directory, this.modelName + ".properties");
    }

    protected void doAction() throws Exception {
        ModelBeanBuilder modelBeanBuilder = new ModelBeanBuilder(false, this.modelName);
        for (File inputFile : this.inputFiles) {
            modelBeanBuilder.addFile(inputFile);
        }
        ModelBean modelBean = modelBeanBuilder.build();
        this.getLog().info((CharSequence)(modelBeanBuilder.getStereotypeHits() + " stereotype(s) detected."));
        this.getLog().info((CharSequence)(modelBeanBuilder.getTagValueHits() + " tag value(s) detected."));
        StringBuilder result = new StringBuilder();
        this.appendMap(modelBean.getTagValues(), "model", result);
        this.appendSet(modelBean.getStereotypes(), "model", result);
        if (modelBean.withPackages()) {
            for (PackageBean packageBean : modelBean.getPackages()) {
                this.appendMap(packageBean.getTagValues(), "package." + packageBean.getName(), result);
                this.appendSet(packageBean.getStereotypes(), "package." + packageBean.getName(), result);
            }
        }
        if (modelBean.withClasses()) {
            for (ClassBean classBean : modelBean.getClasses()) {
                this.appendMap(classBean.getTagValues(), classBean.getName() + ".class", result);
                this.appendSet(classBean.getStereotypes(), classBean.getName() + ".class", result);
                String prefix = classBean.getName() + ".attribute.";
                for (AttributeBean attributeBean : classBean.getAttributes()) {
                    this.appendMap(attributeBean.getTagValues(), prefix + attributeBean.getName(), result);
                    this.appendSet(attributeBean.getStereotypes(), prefix + attributeBean.getName(), result);
                }
            }
        }
        if (this.dryRun) {
            this.getLog().info((CharSequence)("\n\nDryRun mode\ncontent:\n\n" + result.toString() + "\n\n"));
        } else {
            this.getLog().info((CharSequence)("Generate to: " + this.outputFile));
            Files.write((CharSequence)result.toString(), (File)this.outputFile, (Charset)Charset.forName(this.encoding));
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected void appendMap(Map<String, String> map, String prefix, StringBuilder result) {
        if (!map.isEmpty()) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                result.append(prefix).append(".tagValue.").append(entry.getKey()).append("=").append(entry.getValue()).append(this.eol);
            }
        }
    }

    protected void appendSet(Set<String> set, String prefix, StringBuilder result) {
        if (!set.isEmpty()) {
            result.append(prefix).append(".stereotype=").append(Joiner.on((char)',').join(set)).append(this.eol);
        }
    }
}

