/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingbinding.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.PropertyStateEvent;
import org.jdesktop.beansbinding.PropertyStateListener;
import org.jdesktop.observablecollections.ObservableList;
import org.jdesktop.observablecollections.ObservableListListener;
import org.jdesktop.swingbinding.impl.AbstractColumnBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListBindingManager
implements ObservableListListener {
    private AbstractColumnBinding[] bindings = this.getColBindings();
    private ReusableBinding reusableBinding;
    private List<?> elements;
    private List<ColumnDescriptionManager> managers;

    private List<ColumnDescriptionManager> createManagers(AbstractColumnBinding[] bindings) {
        ArrayList<ColumnDescriptionManager> managers = new ArrayList<ColumnDescriptionManager>(bindings.length);
        for (AbstractColumnBinding binding : bindings) {
            managers.add(new ColumnDescriptionManager(binding));
        }
        return managers;
    }

    protected abstract AbstractColumnBinding[] getColBindings();

    public void setElements(List<?> elements, boolean sendAllChanged) {
        if (this.elements != null) {
            if (this.elements instanceof ObservableList) {
                ((ObservableList)this.elements).removeObservableListListener(this);
            }
            if (this.managers != null) {
                for (ColumnDescriptionManager manager : this.managers) {
                    manager.stopListening();
                }
            }
        }
        this.managers = null;
        this.reusableBinding = null;
        this.elements = elements == null ? Collections.emptyList() : elements;
        boolean addListeners = false;
        if (elements instanceof ObservableList) {
            ((ObservableList)elements).addObservableListListener(this);
            addListeners = !((ObservableList)elements).supportsElementPropertyChanged();
        } else if (elements != null) {
            addListeners = true;
        }
        if (this.bindings.length != 0) {
            this.reusableBinding = new ReusableBinding(this.bindings[0]);
        }
        if (addListeners) {
            this.managers = this.createManagers(this.getColBindings());
            for (ColumnDescriptionManager manager : this.managers) {
                manager.startListening();
            }
        }
        if (sendAllChanged) {
            this.allChanged();
        }
    }

    public final Object getElement(int index) {
        return this.elements.get(index);
    }

    public final List<?> getElements() {
        return this.elements;
    }

    public final int size() {
        return this.elements == null ? 0 : this.elements.size();
    }

    public final Object valueAt(int row, int column) {
        if (this.managers != null) {
            for (ColumnDescriptionManager manager : this.managers) {
                manager.validateBinding(row);
            }
        }
        this.reusableBinding.setBaseAndSource(this.bindings[column], this.elements.get(row));
        Binding.ValueResult result = this.reusableBinding.getSourceValueForTarget();
        return result.failed() ? null : result.getValue();
    }

    public final int columnCount() {
        return this.bindings.length;
    }

    @Override
    public final void listElementsAdded(ObservableList list, int index, int length) {
        if (length == 0) {
            return;
        }
        if (this.managers != null) {
            for (ColumnDescriptionManager manager : this.managers) {
                manager.add(index, length);
            }
        }
        this.added(index, length);
    }

    @Override
    public final void listElementsRemoved(ObservableList list, int index, List elements) {
        if (elements.size() == 0) {
            return;
        }
        if (this.managers != null) {
            for (ColumnDescriptionManager manager : this.managers) {
                manager.remove(index, elements.size());
            }
        }
        this.removed(index, elements.size());
    }

    @Override
    public final void listElementReplaced(ObservableList list, int index, Object oldElement) {
        if (this.managers != null) {
            for (ColumnDescriptionManager manager : this.managers) {
                manager.replaced(index);
            }
        }
        this.changed(index);
    }

    @Override
    public final void listElementPropertyChanged(ObservableList list, int index) {
        this.changed(index);
    }

    protected abstract void allChanged();

    protected abstract void valueChanged(int var1, int var2);

    protected abstract void added(int var1, int var2);

    protected abstract void removed(int var1, int var2);

    protected abstract void changed(int var1);

    private final class ReusableBinding
    extends Binding {
        public ReusableBinding(AbstractColumnBinding base) {
            super(null, base.getSourceProperty(), null, base.getTargetProperty(), null);
        }

        public void setBaseAndSource(AbstractColumnBinding base, Object source) {
            this.setSourceProperty(base.getSourceProperty());
            this.setTargetProperty(base.getTargetProperty());
            this.setSourceObject(source);
            this.setConverter(base.getConverter());
            this.setSourceNullValue(base.getSourceNullValue());
            if (base.isSourceUnreadableValueSet()) {
                this.setSourceUnreadableValue(base.getSourceUnreadableValue());
            } else {
                this.unsetSourceUnreadableValue();
            }
        }

        public final void bindImpl() {
        }

        public final void unbindImpl() {
        }
    }

    private final class ColumnDescriptionManager {
        private final AbstractColumnBinding columnBinding;
        private List<EntryWrapper> wrappers;

        ColumnDescriptionManager(AbstractColumnBinding columnBinding) {
            this.columnBinding = columnBinding;
        }

        public void startListening() {
            int size = ListBindingManager.this.elements.size();
            this.wrappers = new ArrayList<EntryWrapper>(size);
            for (int i = 0; i < size; ++i) {
                this.wrappers.add(null);
            }
        }

        public void stopListening() {
            for (EntryWrapper wrapper : this.wrappers) {
                if (wrapper == null) continue;
                wrapper.stopListening();
            }
            this.wrappers = null;
        }

        public void validateBinding(int row) {
            if (this.wrappers.get(row) == null) {
                EntryWrapper wrapper = new EntryWrapper(ListBindingManager.this.getElement(row));
                this.wrappers.set(row, wrapper);
            }
        }

        void wrapperChanged(EntryWrapper wrapper) {
            int row = this.wrappers.indexOf(wrapper);
            ListBindingManager.this.valueChanged(row, this.columnBinding.getColumn());
        }

        private void add(int index, int length) {
            for (int i = 0; i < length; ++i) {
                this.wrappers.add(index, null);
            }
        }

        private void remove(int index, int length) {
            while (length-- > 0) {
                EntryWrapper wrapper = this.wrappers.remove(index);
                if (wrapper == null) continue;
                wrapper.stopListening();
            }
        }

        private void replaced(int index) {
            EntryWrapper wrapper = this.wrappers.get(index);
            if (wrapper != null) {
                wrapper.stopListening();
            }
            this.wrappers.set(index, null);
        }

        private final class EntryWrapper
        implements PropertyStateListener {
            private Object source;

            EntryWrapper(Object source) {
                this.source = source;
                ColumnDescriptionManager.this.columnBinding.getSourceProperty().addPropertyStateListener(source, this);
            }

            public void stopListening() {
                ColumnDescriptionManager.this.columnBinding.getSourceProperty().removePropertyStateListener(this.source, this);
                this.source = null;
            }

            public void propertyStateChanged(PropertyStateEvent pse) {
                if (pse.getValueChanged()) {
                    ColumnDescriptionManager.this.wrapperChanged(this);
                }
            }
        }
    }
}

